<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Utils;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Filesystem\OrderFilesystem;
use CpCreation\VitiCore\Cart\Model\Cart;
use CpCreation\VitiCore\Contact\Model\Contact;
use Knp\Bundle\SnappyBundle\Snappy\Response\PdfResponse;
use Knp\Snappy\Pdf as SnappyPdf;
use Symfony\Contracts\Translation\TranslatorInterface;

class Pdf
{
    private $pdf;
    private $twig;
    private $filesystem;
    private $translator;

    public function __construct(SnappyPdf $pdf, \Twig_Environment $twig, OrderFilesystem $filesystem, TranslatorInterface $translator)
    {
        $this->pdf        = $pdf;
        $this->twig       = $twig;
        $this->filesystem = $filesystem;
        $this->translator = $translator;
    }

    /**
     * @param Contact $contact
     * @param Cart    $cart
     * @param null    $locale
     * @return string
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     */
    public function createPdfOrder(Contact $contact, Cart $cart, $locale = null)
    {
        if ($locale) {
            $this->translator->setLocale($locale);
        }

        $html = $this->twig->render(
            '@CpCreationVitiCore/pdf/order.html.twig', [
                'contact' => $contact,
                'cart'    => $cart,
                'admin' => false,
            ]
        );

        $fileName = 'bon-de-commande_'.$this->skip_accents($cart->getInvoiceAddress()->getLastname()).'_'.date('d-m-Y_H-i').'_'.uniqid().'.pdf';
        $pdf      = new PdfResponse(
            $this->pdf->getOutputFromHtml(
                $html, [
                    'encoding' => 'utf-8',
                ]
            ),
            $fileName
        );

        $this->filesystem->write($fileName, $pdf);

        return $fileName;
    }

    /**
     * @param Contact $contact
     * @param Cart    $cart
     * @param null    $locale
     * @return string
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     */
    public function createPdfOrderAdmin(Contact $contact, Cart $cart, $locale = null)
    {
        if ($locale) {
            $this->translator->setLocale($locale);
        }

        $html = $this->twig->render(
            '@CpCreationVitiCore/pdf/order.html.twig', [
                'contact' => $contact,
                'cart'    => $cart,
                'admin' => true,
            ]
        );

        $fileName = 'bon-de-commande_'.$this->skip_accents($cart->getInvoiceAddress()->getLastname()).'_'.date('d-m-Y_H-i').'_'.uniqid().'.pdf';
        $pdf      = new PdfResponse(
            $this->pdf->getOutputFromHtml(
                $html, [
                    'encoding' => 'utf-8',
                ]
            ),
            $fileName
        );

        $this->filesystem->write($fileName, $pdf);

        return $fileName;
    }
    
    private function skip_accents( $str, $charset='utf-8' ) {
 
      $str = htmlentities( $str, ENT_NOQUOTES, $charset );
    
      $str = preg_replace( '#&([A-za-z])(?:acute|cedil|caron|circ|grave|orn|ring|slash|th|tilde|uml);#', '\1', $str );
      $str = preg_replace( '#&([A-za-z]{2})(?:lig);#', '\1', $str );
      $str = preg_replace( '#&[^;]+;#', '', $str );
    
      return $str;
    }

}