<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Utils;

use CpCreation\VitiCore\Cart\Model\Cart;
use CpCreation\VitiCore\Cart\Model\CartItem;
use CpCreation\VitiCore\Product\Model\ProductPrice;
use CpCreation\VitiCore\Product\Model\ProductPriceCode;
use CpCreation\VitiCore\Product\Model\ProductPriceGroup;
use CpCreation\VitiCore\Product\Model\ProductType;
use CpCreation\VitiCore\Product\Repository\ProductPriceCodeRepository;
use CpCreation\VitiCore\Product\Repository\ProductPriceGroupRepository;
use CpCreation\VitiCore\Product\Repository\ProductTaxRepository;
use CpCreation\VitiCore\Product\Repository\ProductTypeRepository;
use CpCreation\VitiCore\Shop\Model\ShippingAdditional;
use CpCreation\VitiCore\Shop\Model\ShippingConfig;
use CpCreation\VitiCore\Shop\Model\ShippingCountry;
use CpCreation\VitiCore\Shop\Model\ShippingPrice;
use CpCreation\VitiCore\Shop\Repository\ShippingAdditionalRepository;
use CpCreation\VitiCore\Shop\Repository\ShippingAutoRepository;
use CpCreation\VitiCore\Shop\Repository\ShippingAutoSupRepository;
use CpCreation\VitiCore\Shop\Repository\ShippingConfigRepository;
use CpCreation\VitiCore\Shop\Repository\ShippingCountryRepository;
use CpCreation\VitiCore\Shop\Repository\ShippingCountyRepository;
use CpCreation\VitiCore\Shop\Repository\ShippingPriceRepository;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\Intl\Countries;
use Symfony\Contracts\Translation\TranslatorInterface;

class CalculShipping
{
    private $productPriceCodeRepository;
    private $productPriceGroupRepository;
    private $shippingConfigRepository;
    private $productTypeRepository;
    private $productTaxRepository;
    private $shippingCountryRepository;
    private $shippingCountyRepository;
    private $shippingPriceRepository;
    private $shippingAutoRepository;
    private $shippingAutoSupRepository;
    private $shippingAdditionalRepository;
    private $translator;
    private $request;
    private $locale;

    public function __construct(ProductPriceCodeRepository $productPriceCodeRepository,
        ProductPriceGroupRepository $productPriceGroupRepository,
        ShippingConfigRepository $shippingConfigRepository,
        ProductTypeRepository $productTypeRepository,
        ProductTaxRepository $productTaxRepository,
        ShippingCountryRepository $shippingCountryRepository,
        ShippingCountyRepository $shippingCountyRepository,
        ShippingPriceRepository $shippingPriceRepository,
        ShippingAutoRepository $shippingAutoRepository,
        ShippingAutoSupRepository $shippingAutoSupRepository,
        ShippingAdditionalRepository $shippingAdditionalRepository,
        TranslatorInterface $translator,
        RequestStack $request
    ) {
        $this->productPriceCodeRepository   = $productPriceCodeRepository;
        $this->productPriceGroupRepository  = $productPriceGroupRepository;
        $this->shippingConfigRepository     = $shippingConfigRepository;
        $this->productTypeRepository        = $productTypeRepository;
        $this->productTaxRepository         = $productTaxRepository;
        $this->shippingCountryRepository    = $shippingCountryRepository;
        $this->shippingCountyRepository     = $shippingCountyRepository;
        $this->shippingPriceRepository      = $shippingPriceRepository;
        $this->shippingAutoRepository       = $shippingAutoRepository;
        $this->shippingAutoSupRepository    = $shippingAutoSupRepository;
        $this->shippingAdditionalRepository = $shippingAdditionalRepository;
        $this->translator                   = $translator;
        $this->request                      = $request;
        $this->locale                       = $request->getCurrentRequest()->getLocale();
    }

    /**
     * @param Cart $cart
     * @return array
     * @throws \Doctrine\ORM\NonUniqueResultException
     * @throws \Exception
     */
    public function shippingTotalPrice(Cart $cart)
    {
        $items          = $cart->getItems();
        $totalAmount    = 0;
        $deliveryMethod = $cart->getDeliveryMethod();
        if ($cart->getDeliveryAddress()->isDifferentAddress()) {
            $codePostal  = $cart->getDeliveryAddress()->getPostalCode();
            $city        = $cart->getDeliveryAddress()->getCity();
            $countryCode = $cart->getDeliveryAddress()->getCountry();
        } else {
            $codePostal  = $cart->getInvoiceAddress()->getPostalCode();
            $city        = $cart->getInvoiceAddress()->getCity();
            $countryCode = $cart->getInvoiceAddress()->getCountry();
        }
        /** @var ShippingCountry $countryDefault */
        $countryDefault = $this->shippingCountryRepository->findTvaByDefault();
        if ($this->request->getCurrentRequest()->cookies->has('PRICE')) {
            /** @var ProductPriceCode $priceCode */
            $priceCode    = $this->productPriceCodeRepository->findOneBy(['id' => $this->request->getCurrentRequest()->cookies->get('PRICE')]);
            $priceGroup   = $priceCode->getGroup();
            $priceGroupId = $priceGroup->getId()->toString();
            if ($priceGroup->isFreeShipping()) {

                return ['amount' => 0, 'shippingName' => null];
            }
        } else {
            /** @var ProductPriceGroup $priceGroup */
            $priceGroup   = $this->productPriceGroupRepository->findOneBy(['byDefault' => true]);
            $priceGroupId = $priceGroup->getId()->toString();
        }
        //Calcul total for Shipping Free > Amount
        /** @var CartItem $item */
        foreach ($items as $item) {
            /** @var ProductPrice $price */
            foreach ($item->getVariant()->getPrices() as $price) {
                if ($price->getGroup()->getId()->toString() === $priceGroupId) {
                    if ($price->getPriceDiscount()) {
                        $totalAmount = $totalAmount + ($price->getPriceDiscount() * $item->getQuantity());
                    } else {
                        $totalAmount = $totalAmount + ($price->getPrice() * $item->getQuantity());
                    }
                }
            }
        }

        /** @var ShippingConfig $shippingConfig */
        $shippingConfig = $this->shippingConfigRepository->findOne();
        if ($shippingConfig && $shippingConfig->getAmountFreeShipping()) {
            if ($totalAmount >= $shippingConfig->getAmountFreeShipping()) {

                return ['amount' => 0, 'shippingName' => null];
            }
        }

        $amountMarginBank = 0;

        if ($shippingConfig->getAmountMarginBank()) {
            $amountMarginBank = $shippingConfig->getAmountMarginBank();
        }
        /** @var ShippingCountry $countryEm */
        $countryEm = $this->shippingCountryRepository->findOneBy(['code' => $countryCode]);
        if ($countryEm) {
            $taxDefault = $countryEm->getTvaShipping();
        } else {
            $taxDefault = $countryDefault->getTvaShipping();
        }

        $types = $this->productTypeRepository->findAll();
        // Toujours indiquer un type par default pour le calcul des frais de ports offert par nombre de bouteille
        $typeDefault                   = $this->productTypeRepository->findDefaultType();
        $quantities                    = [];
        $quantitiesManu                = [];
        $quantitiesMinCart             = [];
        $quantitiesMinCart1            = [];
        $quantitiesFreeShipping        = [];
        $typesFreeShipping             = [];
        $fdpSupp                       = ceil(($totalAmount * $shippingConfig->getMarginBank()) + $amountMarginBank);
        $fdp                           = 0;
        $fdpTypeMarge                  = 0;
        $fdpTypeMargeWithoutMarge      = 0;
        $fdpPrivateMargePercent        = 0;
        $fdpPrivateMarge               = 0;
        $fdpTypeMargeTotal             = 0;
        $fdpTypeMargeWithoutMargeTotal = 0;
        $fdpManu                       = 0;
        $quantityAllAbsolu             = 0;
        $equivalencies                 = '';
        $shippingName                  = '';
        /** @var ProductType $type */
        foreach ($types as $type) {
            $quantitiesMinCart[$type->getName()]  = 0;
            $quantitiesMinCart1[$type->getName()] = 0;
            if (!$type->isEquivalencyOnShipping()) {
                $quantities[$type->getName()]     = 0;
                $quantitiesManu[$type->getName()] = 0;
                $equivalencies                    .= $type->getName().' = '.$type->getEquivalency().' '.$typeDefault->getName().'<br/>';
            }
            if ($type->isEquivalencyOnFreeShipping()) {
                $typesFreeShipping[] = $type->getName();
            }
        }

        /** @var CartItem $item */
        foreach ($items as $item) {
            // utile pour savoir la quantité d'un contenant pour vérifier la quantité minimum autorisé de ce contenant dans le panier
            //$quantitiesMinCart[$item->getVariant()->getType()->getName()] = $quantitiesMinCart[$item->getVariant()->getType()->getName()] + $item->getQuantity();
            if ($item->getVariant()->getType()->isEquivalencyOnFreeShipping()) {
                $quantitiesFreeShipping[$typeDefault->getName()] = $quantities[$typeDefault->getName()] + ($item->getQuantity() * $item->getVariant()->getType()->getEquivalencyFreeShipping());
            }
            if ($item->getVariant()->getType()->isEquivalencyOnShipping()) {
                //Tout transformer en équivalence bouteille
                $quantities[$typeDefault->getName()]     = $quantities[$typeDefault->getName()] + ($item->getQuantity() * $item->getVariant()->getType()->getEquivalency());
                $quantitiesManu[$typeDefault->getName()] = $quantitiesManu[$typeDefault->getName()] + ($item->getQuantity() * $item->getVariant()->getType()->getEquivalencyManu());
            } else {
                $quantities[$item->getVariant()->getType()->getName()]     = $quantities[$item->getVariant()->getType()->getName()] + $item->getQuantity();
                $quantitiesManu[$item->getVariant()->getType()->getName()] = $quantitiesManu[$item->getVariant()->getType()->getName()] + $item->getQuantity();
            }
            if ($item->getVariant()->getType()->isEquivalencyDefaultQuantity()) {
                $quantitiesMinCart[$typeDefault->getName()] = $quantitiesMinCart[$typeDefault->getName()] + ($item->getQuantity() * $item->getVariant()->getType()->getEquivalency());
            } else {
                $quantitiesMinCart[$item->getVariant()->getType()->getName()] = $quantitiesMinCart[$item->getVariant()->getType()->getName()] + $item->getQuantity();
            }
            $quantityAllAbsolu = $quantityAllAbsolu + ($item->getQuantity() * $item->getVariant()->getType()->getEquivalency());
        }

        if ($shippingConfig->getQtyEquivalencyBottle()) {
            if ($quantityAllAbsolu > $shippingConfig->getQtyEquivalencyBottle()) {
                $quantities                              = [];
                $quantitiesManu                          = [];
                $quantities[$typeDefault->getName()]     = $quantityAllAbsolu;
                $quantitiesManu[$typeDefault->getName()] = $quantityAllAbsolu;
            }
        }

        //Validation de la quantité ( ex: vendu par 6 seulement )
        $messages = null;
        /** @var ProductType $type */
        foreach ($types as $type) {
            if (!$messages) {
                $messages = '';
            }
            if (($quantitiesMinCart[$type->getName()] % $type->getMultipleQuantityCart()) > 0) {
                $messages .= $this->translator->trans(
                        'shop.error.quantity_type', [
                            '%quantity%' => $type->getMultipleQuantityCart(),
                            '%type%'     => $type->getName(),
                        ]
                        , null, $this->locale
                    ).'<br/>';
            }

        }
        if ($messages) {
            throw new \Exception($messages);
        }

        if (($quantitiesMinCart[$typeDefault->getName()] % $typeDefault->getMultipleQuantityCart()) > 0) {
            $messages .= $this->translator->trans(
                    'shop.error.quantity_type', [
                    '%quantity%' => $typeDefault->getMultipleQuantityCart(),
                    '%type%'     => $typeDefault->getName(),
                ], null, $this->locale
                ).'<br/>';
        }


        if ($messages) {
            throw new \Exception($messages);
        }

        /** @var ShippingCountry $country */
        $country = $this->shippingCountryRepository->findOneByGroup($countryCode, $priceGroup);

        if (!$country && !$deliveryMethod) {
            throw new \Exception($this->translator->trans('shop.error.error_country', [], null, $this->locale));
        }

        if ($country && !$deliveryMethod) {
            if ($country->isCounty()) {
                if (!$codePostal) {
                    throw new \Exception($this->translator->trans('shop.error.postal_code', [], null, $this->locale));
                }
            }
        }

        if ($items->count() < 1) {
            throw new \Exception($this->translator->trans('shop.empty_cart', [], null, $this->locale));
        }

        $messages = '';
        $county   = null;

        if ($country) {
            if ($country->isCounty()) {
                $department = substr($codePostal, 0, 2);
                $county     = $this->shippingCountyRepository->findDepartmentByCountry($department, $country->getCode());
                if (!$county && !$deliveryMethod) {
                    throw new \Exception($this->translator->trans('shop.error.empty_shipping', [], null, $this->locale));
                }
            }

            if ($country->getMinQty() && $country->getMultiple() && !$deliveryMethod) {
                if ((($quantitiesMinCart[$typeDefault->getName()] % $country->getMultiple()) > 0) || ($quantitiesMinCart[$typeDefault->getName()] < $country->getMinQty())) {
                    $message = $this->translator->trans(
                            'shop.error.error_country_qty', [
                            '%multiple%' => $country->getMultiple(),
                            '%quantity%' => $country->getMinQty(),
                            '%type%'     => $typeDefault->getName(),
                            '%country%'  => Countries::getName($country->getCode()),
                        ], null, $this->locale
                        ).'<br/>';
                    throw new \Exception($message);
                }
            }
        }


        // Autres modes de livraisons
        if ($deliveryMethod) {
            if ($deliveryMethod->getCategory()->getQtyAt() > $quantityAllAbsolu) {
                $messages .= $this->translator->trans('shop.delivery_method.error_qty', [], null, $this->locale).'<br/>';
            }
            if (!$deliveryMethod->getCounties()->contains($county) && $deliveryMethod->isViewCounties()) {
                $messages .= $this->translator->trans('shop.delivery_method.error_county', [], null, $this->locale).'<br/>';
            }
            if (!empty($messages)) {

                throw new \Exception($messages);
            }
            if ($deliveryMethod->getPackagePrice() >= 0 && !is_null($deliveryMethod->getPackagePrice())) {

                return ['amount' => $deliveryMethod->getPackagePrice(), 'shippingName' => null];
            }

            if ($deliveryMethod->getBottlePrice()) {

                return ['amount' => $deliveryMethod->getBottlePrice() * $quantityAllAbsolu, 'shippingName' => null];
            }
        }

        $freesShipping = $this->shippingPriceRepository->findFreesShippingByGroup($priceGroup, $type);
        if ($freesShipping) {
            if ($quantitiesFreeShipping[$typeDefault->getName()] > $freesShipping->getQtyOf()) {
                foreach ($typesFreeShipping as $typeFreeShipping) {
                    unset($quantities[$typeFreeShipping]);
                }
            }
        }

        $equivalence = 0;
        //Manual
        /** @var ShippingConfig $shippingConfig */
        $shippingConfig = $this->shippingConfigRepository->findOne();
        foreach ($quantitiesManu as $type => $quantity) {
            if ($quantity > 0) {
                /** @var ShippingPrice $shippingPrice */
                if ($country->isCounty()) {
                    $shippingPrice = $this->shippingPriceRepository->findByQuantityAndByTypeAndByZoneAndByGroup($quantity, $type, $county->getZone(), $priceGroup);
                } else {
                    foreach ($country->getZones() as $zone) {
                        $shippingPrice = $this->shippingPriceRepository->findByQuantityAndByTypeAndByZoneAndByGroup($quantity, $type, $zone, $priceGroup);
                        if ($shippingPrice) {
                            break;
                        }
                    }
                }
                if ($shippingPrice) {
                    $shippingName = $shippingPrice->getNameCarrier();
                    //throw new \Exception($this->translator->trans('shop.error.missing_shipping'));
                    if ($shippingPrice->getBottlePrice()) {
                        $fdpType = $shippingPrice->getBottlePrice() * $quantity;
                    } else {
                        $fdpType = $shippingPrice->getPackagePrice();
                    }

                    if ($shippingPrice->getPrivateMargePercent()) {
                        $fdpPrivateMargePercent = ceil($fdpType * $shippingPrice->getPrivateMargePercent());
                    }
                    if ($shippingPrice->getPrivateMarge()) {
                        $fdpPrivateMarge = $shippingPrice->getPrivateMarge();
                    }

                    $fdpType = $fdpType + $fdpPrivateMargePercent;

                    if ($shippingPrice->isConfigGlobal()) {
                        $fdpTypeMarge = $fdpType;
                    } else {
                        $fdpTypeMargeWithoutMarge = $fdpType;
                    }
                    //Somme des transports incluant la marge global
                    $fdpTypeMargeTotal = $fdpTypeMargeTotal + $fdpTypeMarge + $fdpPrivateMarge;
                    // Somme des transports n'incluant pas la marge global
                    $fdpTypeMargeWithoutMargeTotal = $fdpTypeMargeWithoutMargeTotal + $fdpTypeMargeWithoutMarge + $fdpPrivateMarge;

                    unset($quantitiesManu[$type]);
                    unset($quantities[$type]);
                } else {
                    // calcul de l'équivalence restant pour calcul Auto
                    $productType = $this->productTypeRepository->findTypeByName($type);
                    $equivalence = $equivalence + ($quantity * $productType->getEquivalency());
                }
            }
        }
        if ($fdpTypeMargeTotal > 0) {
            if ($shippingConfig->getAmountMinVDManu()) {

                if ($shippingConfig->getAmountFixedManu()) {
                    $fdpTypeMargeTotal = $fdpTypeMargeTotal + $shippingConfig->getAmountFixedManu();
                }

                $taxeVD = round(($fdpTypeMargeTotal + $totalAmount) * $shippingConfig->getMarginManu(), 2);
                if ($taxeVD < $shippingConfig->getAmountMinVDManu()) {
                    $taxeVD = $shippingConfig->getAmountMinVDManu();
                }
                $fdpTypeMargeTotal = $fdpTypeMargeTotal + $taxeVD;
            }
            if ($shippingConfig->getMarginClientManu()) {
                $fdpTypeMargeTotal = $fdpTypeMargeTotal + round($fdpTypeMargeTotal * $shippingConfig->getMarginClientManu(), 2);
            }
        }

        if (!$priceGroup->isViewHT() && ($countryDefault->getCode() == $countryEm->getCode())) {
            if ($shippingConfig->getTvaManu()) {
                $fdpManu = ($fdpTypeMargeTotal * (1 + $shippingConfig->getTvaManu())) + $fdpTypeMargeWithoutMargeTotal;
            } else {
                $fdpManu = $fdpTypeMargeTotal + $fdpTypeMargeWithoutMargeTotal;
            }
        } else {
            $fdpManu = $fdpTypeMargeTotal + $fdpTypeMargeWithoutMargeTotal;
        }

        //Auto
        $searchByHm = false;
        if ($shippingConfig->getCarrier() == "oenotrans") {
            $shippingSup = $this->shippingAutoSupRepository->findOneBy(
                [
                    'country' => $country->getCode(),
                    'county'  => $county->getCode(),
                    'city'    => $city,
                ]
            );
            if ($shippingSup) {
                $searchByHm = true;
            }
        }

        if (count($quantities) > 0 && $equivalence > 0) {
            if ($country->isCounty()) {
                $shippingPrice = $this->shippingAutoRepository->findByQuantityAndByCountyAndByCountry($equivalence, $county->getCode(), $country->getCode(), $searchByHm);
            } else {
                $shippingPrice = $this->shippingAutoRepository->findByQuantityAndByCountry($equivalence, $country->getCode());
            }

            if (!$shippingPrice) {
                throw new \Exception($this->translator->trans('shop.error.missing_shipping', [], null, $this->locale));
            }

            if ($shippingPrice) {
                //throw new \Exception($this->translator->trans('shop.error.missing_shipping'));
                if ($shippingPrice->getBottlePrice()) {
                    $fdp = $fdp + ($shippingPrice->getBottlePrice() * $equivalence);
                } else {
                    $fdp = $fdp + $shippingPrice->getPackagePrice();
                }

                //Taxe VD
                if ($shippingConfig->getAmountMinVDAuto() && $shippingConfig->getAmountPercentVDAuto()) {
                    $fdpVD = round($totalAmount * $shippingConfig->getAmountPercentVDAuto(), 2);
                    if ($fdpVD < $shippingConfig->getAmountMinVDAuto()) {
                        $fdpVD = $shippingConfig->getAmountMinVDAuto();
                    }
                    $fdp = $fdp + $fdpVD;
                }

                $fdp = $fdp + $shippingConfig->getAmountFixedBeforeMargeAuto();

                unset($quantities);
            }
            $shippingSup = $this->shippingAutoSupRepository->findOneBy(
                [
                    'country' => $country->getCode(),
                    'county'  => $county->getCode(),
                    'city'    => $city,
                ]
            );

            if ($shippingSup && $shippingConfig->getCarrier() != "oenotrans") {
                $fdp = $fdp + $shippingConfig->getHighMountainAmount();
            }

            //Taxe avant Gazole
            $fdp = ceil($fdp + ($fdp * $shippingConfig->getMarginAuto()));
            //Taxe Gazole
            $fdp = ceil($fdp + ($fdp * $shippingConfig->getMarginGazoleAuto()));
            //Taxe Après Gazole
            $fdp = ceil($fdp + ($fdp * $shippingConfig->getMarginClientAuto()));

            $fdp          = $fdp + $shippingConfig->getAmountFixedAuto();
            $shippingName = $shippingConfig->getCarrier();
        }

        if (is_null($fdp)) {
            throw new \Exception($this->translator->trans('shop.error.calcul', [], null, $this->locale));
        }
        if ($country->isCounty()) {
            $shippingAdditionals = $this->shippingAdditionalRepository->findByQuantityAndByCountyAndByGroup($equivalence, $county->getCode(), $priceGroup);
            /** @var ShippingAdditional $shippingAdditional */
            foreach ($shippingAdditionals as $shippingAdditional) {
                $fdp = $fdp + $shippingAdditional->getPrice();
            }
        }

        if ($countryDefault->getCode() != $countryEm->getCode()) {
            $shipping = $fdp + $fdpManu + $fdpSupp;

            return ['amount' => $shipping, 'shippingName' => $shippingName];
        }

        //fdpSupp = Marge banque
        if ($priceGroup->isViewHT() || ($countryDefault->getCode() != $countryEm->getCode())) {
            $shipping = $fdp + $fdpManu + $fdpSupp;

            return ['amount' => $shipping, 'shippingName' => $shippingName];
        }

        $fdpTVA   = round($fdp * (1 + $taxDefault), 2) + $fdpManu;
        $shipping = $fdpTVA + $fdpSupp;

        return ['amount' => $shipping, 'shippingName' => $shippingName];
    }
}
