<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Utils;

use CpCreation\VitiCore\Cart\Model\Cart;
use CpCreation\VitiCore\Cart\Model\CartItem;
use CpCreation\VitiCore\Product\Model\ProductDegressive;
use CpCreation\VitiCore\Product\Model\ProductPrice;
use CpCreation\VitiCore\Product\Model\ProductPriceCode;
use CpCreation\VitiCore\Product\Model\ProductPriceGroup;
use CpCreation\VitiCore\Product\Repository\ProductDegressiveRepository;
use CpCreation\VitiCore\Product\Repository\ProductPriceCodeRepository;
use CpCreation\VitiCore\Product\Repository\ProductPriceGroupRepository;
use CpCreation\VitiCore\Product\Repository\ProductTypeRepository;
use CpCreation\VitiCore\Shop\Repository\ShippingCountryRepository;
use Symfony\Component\HttpFoundation\RequestStack;

class CalculDegressive
{
    private $productPriceGroupRepository;

    private $productPriceCodeRepository;

    private $productDegressiveRepository;

    private $productTypeRepository;

    private $priceGroupWithCookie;

    private $request;

    public function __construct(ProductPriceGroupRepository $productPriceGroupRepository,
        ProductDegressiveRepository $productDegressiveRepository,
        ProductTypeRepository $productTypeRepository,
        ProductPriceCodeRepository $productPriceCodeRepository,
        PriceGroupWithCookie $priceGroupWithCookie,
        RequestStack $request
    ) {
        $this->productPriceGroupRepository = $productPriceGroupRepository;
        $this->productPriceCodeRepository  = $productPriceCodeRepository;
        $this->productDegressiveRepository = $productDegressiveRepository;
        $this->productTypeRepository       = $productTypeRepository;
        $this->priceGroupWithCookie        = $priceGroupWithCookie;
        $this->request                     = $request;
    }

    /**
     * @param Cart $cart
     * @return float|int|null
     * @throws \Doctrine\ORM\NonUniqueResultException
     * @throws \Exception
     */
    public function calcul(Cart $cart)
    {
        $degressiveTotal = 0;
        $totalAmount     = 0;
        $cart            = $this->priceGroupWithCookie->convertItemsPriceByCountry($cart);
        $items           = $cart->getItems();
        $equivalencyQty   = 0;
        $allPricesVariant = [];
        if ($this->request->getCurrentRequest()->cookies->has('PRICE')) {
            /** @var ProductPriceCode $priceCode */
            $priceCode    = $this->productPriceCodeRepository->findOneBy(['id' => $this->request->getCurrentRequest()->cookies->get('PRICE')]);
            $priceGroup   = $priceCode->getGroup();
        } else {
            /** @var ProductPriceGroup $priceGroup */
            $priceGroup   = $this->productPriceGroupRepository->findOneBy(['byDefault' => true]);
        }
        $types = [];
        /** @var CartItem $item */
        foreach ($items as $item) {
            $id = $item->getVariant()->getType()->getId()->toString();
            if (isset($types[$id])) {
                $types[$id] = $types[$id] + $item->getQuantity();
            } else {
                $types[$id] = $item->getQuantity();
            }
            array_push($allPricesVariant, $item->getPrice());
            $totalAmount = $totalAmount + ($item->getPrice() * $item->getQuantity());
            $minPriceVariant = min($allPricesVariant);
            $equivalencyQty  = $equivalencyQty + ($item->getVariant()->getType()->getEquivalencyFreeShipping() * $item->getQuantity());
        }

        $typeDefault = $this->productTypeRepository->findDefaultType();
        /** @var ProductDegressive $degressiveByEquivalency */
        $degressiveByEquivalency = $this->productDegressiveRepository->findByQuantityAndByTypeAndByGroupAndByEquivalency($equivalencyQty, $typeDefault->getId()->toString(), $priceGroup);
        if ($degressiveByEquivalency) {
            if ($degressiveByEquivalency->getBottlePrice() || $degressiveByEquivalency->getPackagePrice()) {
                if ($degressiveByEquivalency->getBottlePrice()) {
                    if ($degressiveByEquivalency->isAllQuantity()) {
                        $degressiveTotal = $degressiveTotal + $degressiveByEquivalency->getBottlePrice() * $equivalencyQty;
                    } else {
                        $degressiveTotal = $degressiveTotal + $degressiveByEquivalency->getBottlePrice() * ($equivalencyQty - $degressiveByEquivalency->getQtyOf());
                    }
                } else {
                    $degressiveTotal = $degressiveTotal + $degressiveByEquivalency->getPackagePrice();
                }
            }
            if ($degressiveByEquivalency->getPackagePercent()) {
                $degressiveTotal = $degressiveTotal + ($totalAmount * $degressiveByEquivalency->getPackagePercent());
            }
            if ($degressiveByEquivalency->getQtyOfBottleOffered()) {
                $numberBottleOffered = (floor($equivalencyQty / ($degressiveByEquivalency->getQtyOf() + 1)) * $degressiveByEquivalency->getQtyOfBottleOffered());
                $degressiveTotal     = $degressiveTotal + ($minPriceVariant * $numberBottleOffered);
            }
        } else {
            foreach ($types as $key => $quantity) {
                /** @var ProductDegressive $degressive */
                $degressive = $this->productDegressiveRepository->findByQuantityAndByTypeAndByGroup($quantity, $key, $priceGroup);
                if ($degressive) {

                    if ($degressive->getBottlePrice() || $degressive->getPackagePrice()) {
                        if ($degressive->getBottlePrice()) {
                            if ($degressive->isAllQuantity()) {
                                $degressiveTotal = $degressiveTotal + $degressive->getBottlePrice() * $quantity;
                            } else {
                                $degressiveTotal = $degressiveTotal + $degressive->getBottlePrice() * ($quantity - $degressive->getQtyOf());
                            }
                        } else {
                            $degressiveTotal = $degressiveTotal + $degressive->getPackagePrice();
                        }
                    }
                    if ($degressive->getPackagePercent()) {
                        $degressiveTotal = $degressiveTotal + ($totalAmount * $degressive->getPackagePercent());
                    }
                    if ($degressive->getQtyOfBottleOffered()) {
                        $numberBottleOffered = (floor($equivalencyQty / ($degressive->getQtyOf() + 1)) * $degressive->getQtyOfBottleOffered());
                        $degressiveTotal     = $degressiveTotal + ($minPriceVariant * $numberBottleOffered);
                    }
                }
            }
        }

        if ($degressiveTotal > 0) {
            return $degressiveTotal;
        }

        return null;
    }
}
