<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Twig;

use CpCreation\VitiCore\Product\Repository\ProductPriceCodeRepository;
use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;

class CookiePriceCodeConvertExtension extends AbstractExtension
{

    private $productPriceCodeRepository;

    public function __construct(ProductPriceCodeRepository $productPriceCodeRepository)
    {
        $this->productPriceCodeRepository = $productPriceCodeRepository;
    }

    public function getFilters()
    {
        return [
            new TwigFilter('convert_id_to_name', [$this, 'ConvertIdToNameFilter']),
            new TwigFilter('get_ht_or_ttc', [$this, 'getHtOrTTCFilter']),
        ];
    }

    public function ConvertIdToNameFilter($id)
    {
        $priceCode = $this->productPriceCodeRepository->findOneBy(['id' => $id]);

        return $priceCode->getCode();
    }

    public function getHtOrTTCFilter($id)
    {
        $priceCode = $this->productPriceCodeRepository->findOneBy(['id' => $id]);
        if ($priceCode->getGroup()->isViewHT()) {
            return 'HT';
        }

        return 'TTC';
    }
}