<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Service\Uploader;

use Cocur\Slugify\Slugify;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Filesystem\FileFilesystem;
use CpCreation\VitiCore\Media\Model\File;
use League\Flysystem\Filesystem;
use Symfony\Component\HttpFoundation\File\UploadedFile;

class FileUploader
{
    /**
     * @var Filesystem
     */
    private $filesystem;

    public function __construct(FileFilesystem $filesystem)
    {
        $this->filesystem = $filesystem;
    }

    /**
     * @param UploadedFile $file
     * @return File
     * @throws \Exception
     */
    public function upload(UploadedFile $file)
    {
        $file = $this->uploadFile($file);

        return $file;
    }

    /**
     * @param UploadedFile $uploadedFile
     * @return File
     * @throws \Exception
     */
    private function uploadFile(UploadedFile $uploadedFile)
    {
        $slugify = new Slugify();
        $originalName = $uploadedFile->getClientOriginalName();
        $mimeType = $uploadedFile->getClientMimeType();
        $size = $uploadedFile->getSize();
        $fileName   = $slugify->slugify($originalName).'-'.substr(md5(uniqid()),0,5).'.'.$uploadedFile->guessExtension();
        $stream     = fopen($uploadedFile->getRealPath(), 'r+');
        $this->filesystem->writeStream($fileName, $stream);
        fclose($stream);

        $file = new File();
        $file->setOriginalName($originalName);
        $file->setPath($fileName);
        $file->setMimeType($mimeType);
        $file->setSize($size);

        return $file;
    }
}