(function ($) {
    'use strict';

    var DynamicCollection = function ($container) {
        this.$container = $container;
        this.$index = this.$container.find(':input').length;
        this.$container.on('click', '[data-collection-adder]', this.onAdderClicked.bind(this));
        this.$container.on('click', '[data-collection-remover]', this.onRemoverClicked.bind(this));
    };

    DynamicCollection.prototype = {
        onAdderClicked: function (e) {
            e.preventDefault();

            this.$container.append($(this.$container.data('prototype').replace(/__name__/g, this.$index)));
            this.$index++;
        },
        onRemoverClicked: function (e) {
            e.preventDefault();

            $(e.target).parents('[data-collection-row]:first').remove();
            this.$index--;
        }
    };

    $.fn.dynamicForm = function () {
        return this.each(function () {
            new DynamicCollection($(this));
        });
    };

    $(function () {
        $('[data-prototype]').dynamicForm();
    });

    $('.variant-collection').collection({
        preserve_names: false,
        add: '<a href="#" class="btn btn-default">Ajouter</a>',
        position_field_selector: '.position-form',
        add_at_the_end: true
    });

    $('.room-collection').collection({
        add: '<a href="#" class="btn btn-default">Ajouter</a>',
        add_at_the_end: true,
        children: [{
            selector: '.image-collection',
            min: 1,
            add: '<a href="#" class="btn btn-default">Ajouter</span></a>'
        }],
        after_add: function (collection, element) {
            let trumbowyg = $(element[0]).find('.trumbowyg');
            $.each( trumbowyg, function( key, value ) {
                $(value).trumbowyg({
                    lang: 'fr',
                    svgPath: '/bundles/cpcreationviticore/fonts/icons.svg',
                    btns: [
                        ['viewHTML'],
                        ['undo', 'redo'], // Only supported in Blink browsers
                        ['formatting'],
                        ['strong', 'em', 'del'],
                        ['superscript', 'subscript'],
                        ['link'],
                        ['removeformat'],
                        ['fullscreen']
                    ]

                });
            });
        },
    });
    $('.assemblage-collection').collection({

        'add': '<a href="#" class="btn btn-default">Ajouter</a>',
        'add_at_the_end': true
    });

    $('.image-collection').collection({

        'add': '<a href="#" class="btn btn-default">Ajouter</a>',
        'position_field_selector': '.position-form',
        'add_at_the_end': true
    });
})($);