<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Provider\Payment;

use CpCreation\VitiCore\Cart\Model\Cart;
use CpCreation\VitiCore\Contact\Model\Contact;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\Routing\RouterInterface;

class EtransactionsProvider implements PaymentProviderInterface
{
    const TYPE = 'e-transactions';

    private $router;

    private $path;

    public function __construct(RouterInterface $router,
        $paths
    ) {
        $this->router = $router;
        foreach ($paths as $path) {
            if ($path['name'] === $this->getMethod()) {
                $this->path = $path['path'];
            }
        }
    }

    /**
     * @param Contact $contact
     * @param Cart    $cart
     * @return RedirectResponse
     */
    public function checkout(Contact $contact, Cart $cart)
    {
        return new RedirectResponse(
            $this->router->generate(
                $this->path, [
                    'id' => $cart->getId()->toString(),
                ]
            )
        );
    }

    /**
     * @return string
     */
    public function getMethod(): string
    {
        return static::TYPE;
    }
}