<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Provider\Carrier;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Filesystem\FileFilesystem;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Utils\CheckCity;
use CpCreation\VitiCore\Shop\Model\ShippingAuto;
use CpCreation\VitiCore\Shop\Model\ShippingAutoSup;
use CpCreation\VitiCore\Shop\Model\ShippingConfig;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\RequestStack;

class GeodisProvider implements CarrierProviderInterface
{
    const TYPE = 'geodis';

    /**
     * @var FileFilesystem
     */
    private $filesystem;

    /**
     * @var EntityManagerInterface
     */
    private $em;

    /**
     * @var CheckCity
     */
    private $checkCity;

    /**
     * @var RequestStack
     */
    private $requestStack;

    public function __construct(RequestStack $requestStack,
        FileFilesystem $filesystem,
        EntityManagerInterface $em,
        CheckCity $checkCity
    ) {
        $this->filesystem   = $filesystem;
        $this->em           = $em;
        $this->checkCity    = $checkCity;
        $this->requestStack = $requestStack;
    }

    /**
     * @param ShippingConfig $config
     * @throws \Doctrine\DBAL\DBALException
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     * @throws \PhpOffice\PhpSpreadsheet\Reader\Exception
     * @throws \PhpOffice\PhpSpreadsheet\Writer\Exception
     */
    public function setData(ShippingConfig $config)
    {
        $files   = $this->requestStack->getCurrentRequest()->files->get('shipping_config');
        $file    = $files['file']['file'];
        $fileSup = $files['fileSup']['file'];

        $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        $reader->setReadDataOnly(true);
        if ($file) {
            $spreadsheet = $reader->load($this->filesystem->getAdapter()->getPathPrefix().$config->getFile()->getPath());
            $writer      = new \PhpOffice\PhpSpreadsheet\Writer\Csv($spreadsheet);
            $writer->save($this->filesystem->getAdapter()->getPathPrefix()."geodis.csv");
            if (($handle = fopen($this->filesystem->getAdapter()->getPathPrefix()."geodis.csv", "r")) !== false) {
                $connection = $this->em->getConnection();
                $platform   = $connection->getDatabasePlatform();
                $connection->executeUpdate($platform->getTruncateTableSQL('shop_shipping_auto', true));
                $row                   = 0;
                $shippingQtyCollection = [];
                $zones                 = [];
                while (($data = fgetcsv($handle, 1000, ",")) !== false) {
                    $num = count($data);
                    $row++;
                    for ($c = 0; $c < $num; $c++) {
                        if (strstr($data[$c], 'Zone')) {
                            if (isset($zones[$data[$c]])) {
                                $departments = explode("-", $data[$c + 1]);
                                foreach ($departments as $department) {
                                    array_push($zones[$data[$c]], $department);
                                }

                            } else {
                                $zones[$data[$c]] = [];
                            }

                        } else {
                            if ($data[$c] === "Corse") {
                                $zones[$data[$c]] = [20];
                            }
                        }
                    }
                }
            }
            unset($handle);
            unset($data);
            if (($handle = fopen($this->filesystem->getAdapter()->getPathPrefix()."geodis.csv", "r")) !== false) {
                $row = 0;
                while (($data = fgetcsv($handle, 1000, ",")) !== false) {
                    $num = count($data);
                    $row++;
                    for ($c = 0; $c < $num; $c++) {
                        if ($data[$c] === 'Bouteilles') {
                            for ($d = 2; $d < $num; $d++) {
                                if ($data[$d] != "") {
                                    $parts = explode("à", $data[$d]);
                                    if ($d == 2) {
                                        $shippingQtyCollection[$d]['of'] = 0;
                                        $shippingQtyCollection[$d]['at'] = trim(intval($parts[1]));

                                    } else {

                                        $shippingQtyCollection[$d]['of'] = trim(intval($parts[0]) - 1);
                                        $shippingQtyCollection[$d]['at'] = trim(intval($parts[1]));
                                    }
                                }
                            }
                        }
                        if (strstr($data[$c], 'Zone') || ($data[$c] === "Corse")) {
                            if ($zones[$data[$c]]) {
                                for ($d = 2; $d < $num; $d++) {
                                    if ($data[$d] != "") {
                                        foreach ($zones[$data[$c]] as $department) {
                                            $shipping = new ShippingAuto();
                                            $shipping->setCountry('FR');
                                            $shipping->setCounty($department);
                                            $shipping->setQtyOf($shippingQtyCollection[$d]['of']);
                                            $shipping->setQtyAt($shippingQtyCollection[$d]['at']);
                                            $price = floatval(str_replace(",", ".", $data[$d]));
                                            $shipping->setPackagePrice(intval(strval($price *100)));
                                            $this->em->persist($shipping);
                                        }
                                    }
                                }
                            }

                            $zones[$data[$c]] = false;
                        }
                    }
                }
            }
            $this->em->flush();
            fclose($handle);
            unset($handle);
            unset($data);
        }
        if ($fileSup) {
            $spreadsheet = $reader->load($this->filesystem->getAdapter()->getPathPrefix().$config->getFileSup()->getPath());
            $writer      = new \PhpOffice\PhpSpreadsheet\Writer\Csv($spreadsheet);
            $writer->save($this->filesystem->getAdapter()->getPathPrefix()."geodis_sup.csv");

            if (($handle = fopen($this->filesystem->getAdapter()->getPathPrefix()."geodis_sup.csv", "r")) !== false) {
                $connection = $this->em->getConnection();
                $platform   = $connection->getDatabasePlatform();
                $connection->executeUpdate($platform->getTruncateTableSQL('shop_shipping_auto_sup', true));
                $row = 0;
                while (($data = fgetcsv($handle, 1000, ",")) !== false) {
                    if ($row > 0) {
                        if (strlen($data[1]) < 5)
                        {
                            $data[1] = "0".$data[1];
                        }
                        if (strlen($data[3]) < 2)
                        {
                            $data[3] = "0".$data[3];
                        }
                        $shippingSup = new ShippingAutoSup();
                        $shippingSup->setCountry('FR');
                        $shippingSup->setCounty($data[3]);
                        $shippingSup->setPostal($data[1]);
                        $city = trim($data[2]);
                        /*$city = str_replace(" ST ", " SAINT ", trim($data[2]));
                        $city = str_replace("ST ", "SAINT ", $city);
                        $city = $this->checkCity->check($city, $data[3], $data[1]);
                        if ($city) {
                            $shippingSup->setVerification(1);
                        }*/
                        $shippingSup->setOldName(trim($data[2]));
                        $shippingSup->setCity($city);
                        $this->em->persist($shippingSup);

                    }

                    $row++;
                }
                $this->em->flush();
                unset($data);
                fclose($handle);
                unset($handle);
            }
        }
    }

    /**
     * @return string
     */
    public
    function getCarrier(): string
    {
        return static::TYPE;
    }
}