<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Manager;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Provider\Payment\PaymentProviderInterface;
use CpCreation\VitiCore\Cart\Model\Cart;
use CpCreation\VitiCore\Contact\Model\Contact;

class PaymentProviderManager
{
    private $providers = [] ;

    /**
     * @param PaymentProviderInterface $provider
     */
    public function addProvider(PaymentProviderInterface $provider)
    {
        $this->providers[] = $provider;
    }

    /**
     * @param Contact      $contact
     * @param Cart $cart
     * @return mixed
     * @throws \Exception
     */
    public function createPaymentProviderManager(Contact $contact, Cart $cart)
    {
        foreach ($this->providers as $item)
        {
            if ($item->getMethod() === $cart->getCartCheckout()->getPaymentMethod()->getMethod()){
                return $item->checkout($contact, $cart);
            }
        }

        throw new \Exception("Pas de provider de paiement trouvé");

    }
}
