<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Manager;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\Payment\PaymentMethodInterface;

class PaymentMethodManager
{
    private $methods = [] ;

    /**
     * @param PaymentMethodInterface $method
     */
    public function addMethod(PaymentMethodInterface $method)
    {
        $this->methods[] = $method;
    }

    /**
     * @param $method
     * @return \ReflectionClass
     * @throws \Exception
     * @throws \ReflectionException
     */
    public function createFormPaymentMethodManager($method)
    {
        foreach ($this->methods as $item)
        {
            if ($item->getMethod() === $method){

                return new \ReflectionClass($item);
            }
        }

        throw new \Exception("Pas de paiement de configuré pour ce site");

    }
}