<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use CpCreation\VitiCore\Shop\Model\ShopConfig;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ShopConfigType extends AbstractType
{

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('viewCategory', CheckboxType::class, ['label' => 'Afficher les catégories produits' , 'required' => false])
            ->add('hidePriceDefault', CheckboxType::class, ['label' => 'Afficher la boutique sans prix' , 'required' => false])
            ->add('enableAwardShop', CheckboxType::class, ['label' => 'Afficher les médailles sur les produits dans la boutique' , 'required' => false])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => ShopConfig::class
            ]
        );
    }
}
