<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use A2lix\TranslationFormBundle\Form\Type\TranslatedEntityType;
use CpCreation\VitiCore\Product\Model\ProductPriceGroup;
use CpCreation\VitiCore\Shop\Model\ShippingPrice;
use CpCreation\VitiCore\Shop\Model\ShippingZone;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\MoneyType;
use Symfony\Component\Form\Extension\Core\Type\PercentType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;
use CpCreation\VitiCore\Product\Model\ProductType as ModelProductType;

class ShippingPriceType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('qtyOf', IntegerType::class, ['label' => 'De (>)', 'required' => true])
            ->add('qtyAt', IntegerType::class, ['label' => 'A (<=)', 'required' => true])
            ->add(
                'types', TranslatedEntityType::class,
                [
                    'class'                => ModelProductType::class,
                    'translation_property' => 'name',
                    'label'                => 'Type(s) pris en compte',
                    'multiple'             => true,
                    'required'             => true,
                    'attr'                 => [
                        'class' => 'select2',
                    ],
                ]
            )
            ->add(
                'packagePrice', MoneyType::class,
                [
                    'divisor'  => 100,
                    'label'    => 'Forfait (HT si marge global coché ou TTC)',
                    'required' => false,
                ]
            )
            ->add(
                'bottlePrice', MoneyType::class,
                [
                    'divisor'  => 100,
                    'label'    => 'Par bouteille (HT si marge global coché ou TTC)',
                    'required' => false,
                ]
            )
            ->add('nameCarrier', TextType::class, ['label' => 'Nom du transporteur', 'required' => true])
            ->add(
                'configGlobal', CheckboxType::class, [
                    'label'    => 'Activer la configuration globale manuelle ( Ajout de Marge, de taxe, TVA, ... )',
                    'required' => false,
                ]
            )
            ->add(
                'privateMargePercent', PercentType::class, [
                    'scale'    => 2,
                    'label'    => 'Marge spécifique en % à ce frais de port (Ajout avant marge global)',
                    'required' => false,
                ]
            )
            ->add(
                'privateMarge', MoneyType::class,
                [
                    'divisor'  => 100,
                    'label'    => 'Marge spécifique en euro à ce frais de port (Ajout avant marge global)',
                    'required' => false,
                ]
            )
            ->add(
                'zones', EntityType::class,
                [
                    'class'        => ShippingZone::class,
                    'choice_label' => 'name',
                    'label'        => 'Zone(s)',
                    'multiple'     => true,
                    'required'     => true,
                    'attr'         => [
                        'class' => 'select2',
                    ],
                ]
            )
            ->add(
                'groups', EntityType::class,
                [
                    'class'        => ProductPriceGroup::class,
                    'choice_label' => 'name',
                    'label'        => 'Groupes de prix',
                    'multiple'     => true,
                    'required'     => true,
                    'attr'         => [
                        'class' => 'select2',
                    ],
                ]
            );

    }


    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => ShippingPrice::class,
            ]
        );
    }
}
