<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;


use CpCreation\VitiCore\Product\Model\ProductPriceGroup;
use CpCreation\VitiCore\Shop\Model\ShippingCountry;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\CountryType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\PercentType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ShippingCountryType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'code', CountryType::class,
                [
                    'label'    => 'Pays',
                    'multiple' => false,
                    'attr'     => [
                        'class' => 'select2',
                    ],
                    'required' => true,
                ]
            )
            ->add(
                'county', CheckboxType::class,
                [
                    'label' => 'Activer la gestion des départements ',
                ]
            )
            ->add(
                'disabled', CheckboxType::class,
                [
                    'label' => 'Désactiver le pays',
                ]
            )
            ->add(
                'minQty', IntegerType::class,
                [
                    'label'    => 'Quantité minimum (équivalence bouteille) pour commander vers ce pays avec le groupe désigné ci-dessous. Ne rien mettre si on prend la configuration par défaut',
                    'required' => false,
                ]
            )
            ->add(
                'multiple', IntegerType::class,
                [
                    'label'    => 'Multiple (équivalence bouteille) pour commander vers ce pays avec le groupe désigné ci-dessous. Ne rien mettre si on prend la configuration par défaut',
                    'required' => false,
                ]
            )
            ->add(
                'tvaCustomer', PercentType::class, [
                'label'    => 'Valeur de la Tva pour les particuliers (TVA du pays pour les boissons alcoolisées)',
                'required' => true,
            ])
            ->add(
                'tvaPro', PercentType::class, [
                'label'    => 'Valeur de la Tva pour les professionnels (Souvent 0)',
                'required' => true,
            ])
            ->add(
                'byDefault', CheckboxType::class, [
                'label'    => 'Pays par default pour la boutique en ligne',
            ])
            ->add(
                'groups', EntityType::class,
                [
                    'class'        => ProductPriceGroup::class,
                    'choice_label' => 'name',
                    'label'        => 'Groupes de prix',
                    'multiple'     => true,
                    'required'     => true,
                    'attr'         => [
                        'class' => 'select2',
                    ],
                ]
            );
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => ShippingCountry::class,
            ]
        );
    }
}
