<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use CpCreation\VitiCore\Cart\Model\Promo;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\MoneyType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\PercentType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class PromoType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('title', TextType::class, ['label' => 'Code promo', 'required' => true])
            ->add(
                'minEquivalency', IntegerType::class, [
                    'required' => false,
                    'label'    => 'Quantité minimum de commande (équivalence bouteille)',
                ]
            )
            ->add(
                'percent', PercentType::class, [
                    'required' => false,
                    'label'    => 'Remise pourcentage sur le montant du panier',
                ]
            )
            ->add(
                'amount', MoneyType::class, [
                    'divisor'  => 100,
                    'required' => false,
                    'label'    => 'Remise en euros sur le montant du panier',
                ]
            )
            ->add(
                'maxCount', NumberType::class, [
                    'required' => false,
                    'html5'    => true,
                    'label'    => 'Limiter le nombre d\'utilisation de ce code',
                ]
            )
            ->add(
                'beginAt', DateTimeType::class, [
                    'required' => true,
                    'label'    => 'Date de début',
                    'input'    => 'datetime',
                    'format'   => 'yyyy-MM-dd HH:mm',
                    'widget'   => 'single_text',
                    'attr'     => [
                        'class' => 'datetimepicker',
                    ],
                ]
            )
            ->add(
                'endAt', DateTimeType::class, [
                    'required' => true,
                    'label'    => 'Date de fin',
                    'input'    => 'datetime',
                    'format'   => 'yyyy-MM-dd HH:mm',
                    'widget'   => 'single_text',
                    'attr'     => [
                        'class' => 'datetimepicker',
                    ],
                ]
            )
            ->add(
                'disabled', ChoiceType::class, [
                    'required' => true,
                    'label'    => 'Publier',
                    'choices'  => [
                        "Oui" => false,
                        "Non" => true,
                    ],
                ]
            );
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => Promo::class,
            ]
        );
    }
}
