<?php

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use A2lix\TranslationFormBundle\Form\Type\TranslationsType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use CpCreation\VitiCore\Product\Model\ProductType as ModelProductType;

/**
 * @author Colinet Julien
 */
class ProductTypeType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('volume', NumberType::class, [
                'required' => false,
                'label'      => 'Volume'
            ])
            ->add('unity', ChoiceType::class, [
                'label'          => 'Unité',
                'required' => false,
                'choices' => [
                    'Centilitre' => 'cl',
                    'Litre' => 'L',
                    'Gramme' => 'g',
                    'Kilogramme' => 'kg',
                    'unité' => 'unity'
                ]
            ])
            ->add('multipleQuantityCart', IntegerType::class, [
                'label'          => 'Multiple minimum',
                'required' => true,
            ])
            ->add('equivalencyManu', NumberType::class, [
                'label'          => 'Equivalence Bouteille pour frais de port ( Mode Manuel )',
                'required' => true,
            ])
            ->add('equivalency', NumberType::class, [
                'label'          => 'Equivalence Bouteille pour frais de port ( Mode Auto )',
                'required' => true,
            ])
            ->add('equivalencyFreeShipping', NumberType::class, [
                'label'          => 'Equivalence Bouteille pour calcul expédition gratuite à partir d\'un certain nombre de bouteille ',
                'required' => false,
            ])
            ->add('equivalencyDefault', CheckboxType::class, [
                'label'          => 'Equivalence par défaut',
                'required' => false,
            ])

            ->add('equivalencyOnShipping', CheckboxType::class, [
                'label'          => 'Prendre en compte en équivalence bouteille pour frais de port rentré manuellement ( Par rapport Equivalence par défaut )',
                'required' => false,
            ])
            ->add('equivalencyOnShipping', CheckboxType::class, [
                'label'          => 'Prendre en compte en équivalence bouteille pour frais de port rentré manuellement ( Par rapport Equivalence par défaut )',
                'required' => false,
            ])
            ->add('equivalencyOnFreeShipping', CheckboxType::class, [
                'label'          => 'Prendre en compte en équivalence bouteille pour calcul frais de port gratuit par nombre de bouteille.',
                'required' => false,
            ])
            ->add('equivalencyDefaultQuantity', CheckboxType::class, [
                'label'          => 'Ajouter à la quantité par défaut pour générer l\'alerte de quantité minimum, si pas cocher la quantité du type sera prioritaire et ne sera pas ajouté sur la quantité par défaut(bouteille)',
                'required' => false,
            ])
            ->add(
                'translations', TranslationsType::class, [
                    'label' => false,
                    'fields' => [
                        'name' => [
                            'field_type' => TextType::class,
                            'label'      => 'Nom',
                            'required'   => true,
                        ],
                    ],
                    'excluded_fields' => ['slug']
                ]
            );
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => ModelProductType::class,
            ]
        );
    }
}
