<?php

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use CpCreation\VitiCore\Product\Model\ProductPrice;
use CpCreation\VitiCore\Product\Model\ProductPriceGroup;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\MoneyType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * Created by Colinet Julien
 */
class ProductPriceType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'group', EntityType::class, [
                'class'        => ProductPriceGroup::class,
                'disabled'     => true,
                'attr'         => [
                    'class' => 'hidden',
                ],
                'label' => false,
                'choice_label' => 'name',
            ]
            )
            ->add(
                'price', MoneyType::class, [
                    'required' => true,
                    'label'    => 'Prix TTC ou HT (Pro)',
                    'divisor'  => 100,
                ]
            )
            ->add(
                'priceDiscount', MoneyType::class, [
                    'required' => false,
                    'label'    => 'Prix Remisé TTC ou HT (Pro)',
                    'divisor'  => 100,
                ]
            );
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => ProductPrice::class,
            ]
        );
    }

}
