<?php

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use A2lix\TranslationFormBundle\Form\Type\TranslationsType;
use CpCreation\VitiCore\Product\Model\ProductCategory;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * @author Colinet Julien
 */
class ProductCategoryType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'translations', TranslationsType::class, [
                    'label'  => false,
                    'fields' => [
                        'name' => [
                            'field_type' => TextType::class,
                            'label'      => 'Nom',
                            'required'   => true,
                        ],
                        'description' => [
                            'field_type' => TrumbowygType::class,
                            'label'      => 'description',
                            'required'   => false,
                        ]
                    ],
                    'excluded_fields' => ['slug']
                ]
            );
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => ProductCategory::class,
            ]
        );
    }
}