<?php

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;


use A2lix\TranslationFormBundle\Form\Type\TranslationsType;
use CpCreation\VitiCore\History\Model\History;
use CpCreation\VitiCore\History\Model\HistoryImage;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * @author Colinet Julien
 */
class HistoryType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'translations', TranslationsType::class, [
                    'label'            => false,
                    'fields'           => [
                        'title'    => [
                            'field_type' => TextType::class,
                            'label'      => 'Titre',
                            'required'   => true,
                        ],
                        'subtitle'    => [
                            'field_type' => TextType::class,
                            'label'      => 'Sous titre',
                            'required'   => true,
                        ],
                        'text'     => [
                            'field_type' => TrumbowygType::class,
                            'label'      => 'Texte',
                            'required'   => false,
                        ],
                    ],
                    'required_locales' => ['fr','en'],
                    'excluded_fields'  => ['slug'],
                ]
            )
            ->add(
                'images', ImageCollectionType::class, [
                    'label'          => false,
                    'entry_type'     => HistoryImageType::class,
                    'allow_add'      => true,
                    'allow_delete'   => true,
                    'error_bubbling' => false,
                    'prototype'      => true,
                    'by_reference'   => true,
                    'delete_empty'   => true,
                    'attr'           => [
                        'data-name-prefix' => 'Image',
                        'class'            => "image-collection",
                    ],
                    'entry_options'  => [
                        'data_class' => HistoryImage::class,
                        'label'      => false,
                    ],
                ]
            )
            ->add(
                'video', VideoType::class, ['label' => 'Vidéo ( Numéro de la vidéo, ex : nFoT4Z-0HIQ )', 'required' => false]
            )
            ->add(
                'file', FileType::class, ['label' => 'Fiche a télécharger avec la news', 'required' => false]
            )
            ->add(
                'disabled', CheckboxType::class, ['label' => 'Dépublié', 'required' => false]
            );
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => History::class,
            ]
        );
    }
}
