<?php

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use A2lix\TranslationFormBundle\Form\Type\TranslationsType;
use CpCreation\VitiCore\Shop\Model\DeliveryMethodCategory;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * @author Colinet Julien
 */
class DeliveryMethodCategoryType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'translations', TranslationsType::class, [
                    'label'  => false,
                    'fields' => [
                        'name' => [
                            'field_type' => TextType::class,
                            'label'      => 'Nom de la méthode de livraison',
                            'required'   => true,
                        ],
                        'description' => [
                            'field_type' => TrumbowygType::class,
                            'label'      => 'Description de la méthode de livraison',
                            'required'   => false,
                        ],
                    ],
                    'excluded_fields' => ['slug']
                ]
            )
            ->add('qtyAt', IntegerType::class, ['label' => 'Quantité minimum de bouteille pour choisir cette méthode de livraison', 'required' => true])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => DeliveryMethodCategory::class,
            ]
        );
    }
}
