<?php

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\DependencyInjection;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\Payment\PaymentMethodInterface;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\SocialNetwork\SocialNetworkNetworkInterface;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Provider\Carrier\CarrierProviderInterface;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Provider\Payment\PaymentProviderInterface;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Provider\SocialNetwork\SocialNetworkProviderInterface;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\Extension\PrependExtensionInterface;
use Symfony\Component\DependencyInjection\Loader;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

class CpCreationVitiCoreExtension extends Extension implements PrependExtensionInterface
{

    public function load(array $configs, ContainerBuilder $container)
    {
        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__.'/../Resources/config'));
        $loader->load('services.yaml');
        $configuration = new Configuration();
        $config        = $this->processConfiguration($configuration, $configs);
        $container->setParameter('cp_creation_viti_core.payment_method', $config['payment_method']);
        $container->setParameter('cp_creation_viti_core.social_network', $config['social_network']);
        $container->setParameter('cp_creation_viti_core.return_path', $config['return_path']);
        $container->setParameter('cp_creation_viti_core.carriers', $config['carriers']);
        $container->setParameter('cp_creation_viti_core.maintenance_email', $config['maintenance_email']);
        $container->setParameter('knp.doctrine_behaviors.translatable_subscriber.translatable_trait', 'CpCreation\VitiCore\Behavior\Impl\Translatable');
        $container->setParameter('knp.doctrine_behaviors.translatable_subscriber.translation_trait', 'CpCreation\VitiCore\Behavior\Impl\Translation');

        #$container->registerForAutoconfiguration(PaymentProviderInterface::class)->addTag('viti-core.provider.payment');
        #$container->registerForAutoconfiguration(PaymentMethodInterface::class)->addTag('viti-core.form.payment_method');
        #$container->registerForAutoconfiguration(SocialNetworkProviderInterface::class)->addTag('viti-core.provider.socialnetwork');
        #$container->registerForAutoconfiguration(SocialNetworkNetworkInterface::class)->addTag('viti-core.form.social_network');
        #$container->registerForAutoconfiguration(CarrierProviderInterface::class)->addTag('viti-core.provider.carrier');

    }

    public function prepend(ContainerBuilder $container)
    {
        $package = new Loader\YamlFileLoader($container, new FileLocator(__DIR__.'/../Resources/config/packages'));
        $bundles = $container->getParameter('kernel.bundles');
        if (isset($bundles['OneupFlysystemBundle'])) {
            $package->load('oneup_flysystem.yaml');
        }
        if (isset($bundles['LiipImagineBundle'])) {
            $package->load('imagine.yaml');
        }
        if (isset($bundles['ApiPlatformBundle'])) {
            $package->load('api_platform.yaml');
        }
        if (isset($bundles['StofDoctrineExtensionsBundle'])) {
            $package->load('stof_doctrine_extensions.yaml');
        }
        if (isset($bundles['TwigBundle'])) {
            $package->load('twig.yaml');
            $package->load('twig_extensions.yaml');
        }
        if (isset($bundles['CpCreationVitiCoreBundle'])) {
            $package->load('viticore.yaml');

        }
        if (isset($bundles['DoctrineBehaviorsBundle'])) {
            $package->load('knp_doctrine_behaviors.yaml');
        }
        if (isset($bundles['DoctrineBundle'])) {
            $package->load('doctrine.yaml');
        }
        if (isset($bundles['A2lixTranslationFormBundle'])) {

            $package->load('a2lix.yaml');
        }
        if (isset($bundles['EightPointsGuzzleBundle'])) {

            $package->load('eight_points_guzzle.yaml');
        }
        if (isset($bundles['BazingaJsTranslationBundle'])) {
            $package->load('translations.yaml');
        }
        if (isset($bundles['KnpPaginatorBundle'])) {
            $package->load('knp_paginator.yaml');
        }
        $package->load('framework.yaml');
        $package->load('security.yaml');
    }
}
