<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\ShopConfigType;
use CpCreation\VitiCore\Shop\Model\ShopConfig;
use CpCreation\VitiCore\Shop\Repository\ShopConfigRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

/**
 * @IsGranted({"ROLE_ADMIN"})
 * Class ShopConfigController
 * @package CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin
 * @Route("/shop-config")
 */
class ShopConfigController extends AbstractController
{
    private $shopConfigRepository;

    public function __construct(ShopConfigRepository $shopConfigRepository)
    {
        $this->shopConfigRepository =  $shopConfigRepository;
    }

    /**
     * @route("", name="admin_shop_config")
     * @Template("@CpCreationVitiCore/admin/shop/config/index.html.twig")
     */
    public function indexAction()
    {
        $config = $this->shopConfigRepository->findAll();

        return [
            "items" => $config,
        ];
    }


    /**
     * @param Request $request
     * @Route("/new", name="admin_shop_config_new")
     * @Template("@CpCreationVitiCore/admin/shop/config/new.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function newAction(Request $request)
    {

        $form = $this->createForm(ShopConfigType::class);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var ShopConfig $data */
            $data = $form->getData();
            $this->shopConfigRepository->save($data);
            $this->addFlash('alert-success', 'La configuration a été ajouté avec succès');

            return $this->redirectToRoute('admin_shop_config');

        }

        return [
            "form" => $form->createView(),
        ];
    }

    /**
     * @param ShopConfig $config
     * @param Request $request
     * @Route("/{id}/edit", name="admin_shop_config_edit")
     * @Template("@CpCreationVitiCore/admin/shop/config/edit.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function editAction(ShopConfig $config, Request $request)
    {
        $form = $this->createForm(ShopConfigType::class, $config);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var ShopConfig $data */
            $data = $form->getData();
            $this->shopConfigRepository->save($data);
            $this->addFlash('alert-success', 'La configuration a été modifié avec succès');

            return $this->redirectToRoute('admin_shop_config');

        }

        return [
            "item" => $config,
            "form" => $form->createView(),
        ];
    }

    /**
     * @param ShopConfig $config
     * @Route("/{id}/delete", name="admin_shop_config_delete")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function deleteAction(ShopConfig $config)
    {
        $this->shopConfigRepository->delete($config);
        $this->addFlash('alert-success', 'La configuration a été supprimé avec succès.');

        return $this->redirectToRoute('admin_shop_config');
    }
}
