<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\ProductTypeType;
use CpCreation\VitiCore\Product\Model\ProductType;
use CpCreation\VitiCore\Product\Repository\ProductTypeRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

/**
 * @IsGranted({"ROLE_ADMIN"})
 * Class ProductTypeController
 * @package CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin
 * @Route("/product-type")
 */
class ProductTypeController extends AbstractController
{
    private $productTypeRepository;

    public function __construct(ProductTypeRepository $productTypeRepository)
    {
        $this->productTypeRepository =  $productTypeRepository;
    }

    /**
     * @route("", name="admin_product_type")
     * @Template("@CpCreationVitiCore/admin/product/type/index.html.twig")
     */
    public function indexAction()
    {
        $zones = $this->productTypeRepository->findBy([], ['createdAt' => 'ASC']);

        return [
            "items" => $zones,
        ];
    }


    /**
     * @param Request $request
     * @Route("/new", name="admin_product_type_new")
     * @Template("@CpCreationVitiCore/admin/product/type/new.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function newAction(Request $request)
    {

        $form = $this->createForm(ProductTypeType::class);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var ProductType $data */
            $data = $form->getData();
            $this->productTypeRepository->save($data);
            $this->addFlash('alert-success', 'Le type '.$data->getName().' a été ajouté avec succès');

            return $this->redirectToRoute('admin_product_type');

        }

        return [
            "form" => $form->createView(),
        ];
    }

    /**
     * @param ProductType $type
     * @param Request $request
     * @Route("/{id}/edit", name="admin_product_type_edit")
     * @Template("@CpCreationVitiCore/admin/product/type/edit.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function editAction(ProductType $type, Request $request)
    {
        $form = $this->createForm(ProductTypeType::class, $type);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var ProductType $data */
            $data = $form->getData();
            $this->productTypeRepository->save($data);
            $this->addFlash('alert-success', 'Le type '.$type->getName().' a été modifié avec succès');

            return $this->redirectToRoute('admin_product_type');

        }

        return [
            "item" => $type,
            "form" => $form->createView(),
        ];
    }

    /**
     * @param ProductType $type
     * @Route("/{id}/delete", name="admin_product_type_delete")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function deleteAction(ProductType $type)
    {
        $this->productTypeRepository->delete($type);
        $this->addFlash('alert-success', 'Le type '.$type->getName().' a été supprimé avec succès.');

        return $this->redirectToRoute('admin_product_type');
    }
}
