<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\ProductPriceGroupType;
use CpCreation\VitiCore\Product\Model\ProductPriceGroup;
use CpCreation\VitiCore\Product\Repository\ProductPriceGroupRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

/**
 * @IsGranted({"ROLE_ADMIN"})
 * Class ProductPriceGroupController
 * @package CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin
 * @Route("/product-price-group")
 */
class ProductPriceGroupController extends AbstractController
{
    private  $productPriceGroupRepository;

    public function __construct(ProductPriceGroupRepository $productPriceGroupRepository)
    {
        $this->productPriceGroupRepository =  $productPriceGroupRepository;
    }

    /**
     * @route("", name="admin_product_price_group")
     * @Template("@CpCreationVitiCore/admin/product/price/group/index.html.twig")
     */
    public function indexAction()
    {
        $groups = $this->productPriceGroupRepository->findBy([], ['position' => 'ASC']);

        return [
            "items" => $groups
        ];
    }


    /**
     * @param Request $request
     * @Route("/new", name="admin_product_price_group_new")
     * @Template("@CpCreationVitiCore/admin/product/price/group/new.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function newAction(Request $request)
    {

        $form = $this->createForm(ProductPriceGroupType::class);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var ProductPriceGroup $data */
            $data = $form->getData();
            $this->productPriceGroupRepository->save($data);
            $this->addFlash('alert-success', 'Le groupe de prix '.$data->getName().' a été ajouté avec succès');

            return $this->redirectToRoute('admin_product_price_group');

        }

        return [
            "form" => $form->createView(),
        ];
    }

    /**
     * @param ProductPriceGroup $group
     * @param Request $request
     * @Route("/{id}/edit", name="admin_product_price_group_edit")
     * @Template("@CpCreationVitiCore/admin/product/price/group/edit.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function editAction(ProductPriceGroup $group, Request $request)
    {
        $form = $this->createForm(ProductPriceGroupType::class, $group);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var ProductPriceGroup $data */
            $data = $form->getData();
            $this->productPriceGroupRepository->save($data);
            $this->addFlash('alert-success', 'Le groupe de prix '.$group->getName().' a été modifié avec succès');

            return $this->redirectToRoute('admin_product_price_group');

        }

        return [
            "item" => $group,
            "form" => $form->createView(),
        ];
    }

    /**
     * @param ProductPriceGroup $group
     * @Route("/{id}/delete", name="admin_product_price_group_delete")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function deleteAction(ProductPriceGroup $group)
    {
        $this->productPriceGroupRepository->delete($group);
        $this->addFlash('alert-success', 'Le groupe de prix '.$group->getName().' a été supprimé avec succès.');

        return $this->redirectToRoute('admin_product_price_group');
    }

    /**
     * @param ProductPriceGroup $group
     * @Route("/{id}/moveUp", name="admin_product_price_group_move_up")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function moveUpAction(ProductPriceGroup $group)
    {
        $group->setPosition($group->getPosition() - 1);
        $this->productPriceGroupRepository->save($group);
        $this->addFlash('alert-success', 'Le groupe de prix '.$group->getName().' a été remonté.');

        return $this->redirectToRoute('admin_product_price_group');
    }

    /**
     * @param ProductPriceGroup $group
     * @Route("/{id}/moveDown", name="admin_product_price_group_move_down")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function moveDownAction(ProductPriceGroup $group)
    {
        $group->setPosition($group->getPosition() + 1);
        $this->productPriceGroupRepository->save($group);
        $this->addFlash('alert-success', 'Le groupe de prix '.$group->getName().' a été descendu.');

        return $this->redirectToRoute('admin_product_price_group');
    }
}
