<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin;

use CpCreation\VitiCore\News\Model\News;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\NewsType;
use CpCreation\VitiCore\News\Repository\NewsRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Request;

/**
 * @IsGranted({"ROLE_ADMIN","ROLE_NEWS"})
 * Class NewsController
 *
 * @package CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin
 * @Route("/news")
 */
class NewsController extends AbstractController
{
    private $newsRepository;

    public function __construct(NewsRepository $newsRepository)
    {
        $this->newsRepository = $newsRepository;
    }

    /**
     * @route("", name="admin_news")
     * @Template("@CpCreationVitiCore/admin/news/index.html.twig")
     */
    public function indexAction()
    {
        $news = $this->newsRepository->findBy([], ['eventAt' => 'DESC']);

        return [
            "items" => $news,
        ];
    }

    /**
     * @param Request $request
     * @Route("/new", name="admin_news_new")
     * @Template("@CpCreationVitiCore/admin/news/new.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function newAction(Request $request)
    {

        $form = $this->createForm(NewsType::class);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var News $data */
            $data = $form->getData();
            $this->newsRepository->save($data);
            $this->addFlash('alert-success', 'La news '.$data->getTitle().' a été ajouté avec succès');

            return $this->redirectToRoute('admin_news');

        }

        return [
            "form" => $form->createView(),
        ];
    }

    /**
     * @param News    $news
     * @param Request $request
     * @Route("/{id}/edit", name="admin_news_edit")
     * @Template("@CpCreationVitiCore/admin/news/edit.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function editAction(News $news, Request $request)
    {
        $form = $this->createForm(NewsType::class, $news);
        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            /** @var News $data */
            $data = $form->getData();
            $data->setUpdatedAt(new \DateTime()); // Forcer Update de doctrine
            $this->newsRepository->save($data);
            $this->addFlash('alert-success', 'La news '.$news->getTitle().' a été modifié avec succès');

            return $this->redirectToRoute('admin_news');

        }

        return [
            "item" => $news,
            "form" => $form->createView(),
        ];
    }

    /**
     * @param News $news
     * @Route("/{id}/delete", name="admin_news_delete")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function deleteAction(News $news)
    {
        $this->newsRepository->delete($news);
        $this->addFlash('alert-success', 'La récompense '.$news->getTitle().' a été supprimé avec succès.');

        return $this->redirectToRoute('admin_news');
    }
}
