<?php

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Command;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Filesystem\ImageFilesystem;
use League\Flysystem\Filesystem;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Symfony\Component\DependencyInjection\ContainerAwareTrait;
use Symfony\Component\Finder\Finder;

/**
 * @author Colinet Julien
 */

class UploadStubsCommand extends Command implements ContainerAwareInterface
{
    use ContainerAwareTrait;

    private $imageFilesystem;

    public function __construct(?string $name = null, ImageFilesystem $imageFilesystem) {
        parent::__construct($name);
        $this->imageFilesystem = $imageFilesystem;
    }

    protected function configure()
    {
        $this->setName('viti-core:upload-stubs');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $io = new SymfonyStyle($input, $output);

        $io->comment('Copy image produt to public directory …');

        /** @var Filesystem $filesystem */
        $filesystem = $this->imageFilesystem;
        foreach (Finder::create()->in(__DIR__ . '/../../../../fixtures/stubs')->getIterator() as $file) {
            $relativePath = substr($file, strlen(__DIR__ . '/../../../../fixtures/stubs/'));

            if ($filesystem->has($relativePath)) {
                $io->comment($relativePath . ' is already uploaded');

                continue;
            }

            $io->comment('Uploading ' . $relativePath . '…');
            $filesystem->write($relativePath, file_get_contents($file));
        }
    }


}