<?php

namespace CpCreation\VitiCore\Bridge\Doctrine\Filter;

use CpCreation\VitiCore\Behavior\IsSoftDeletable;
use Doctrine\ORM\Mapping\ClassMetadata;
use Doctrine\ORM\Query\Filter\SQLFilter;

/**
 * @author Colinet Julien
 */
final class SoftDeletableFilter extends SQLFilter
{
    /**
     * @param ClassMetadata $targetEntity
     * @param string        $targetTableAlias
     * @return string
     */
    public function addFilterConstraint(ClassMetadata $targetEntity, $targetTableAlias)
    {
        foreach ($targetEntity->getReflectionClass()->getInterfaces() as $interface) {
            if ($interface->getName() === IsSoftDeletable::class) {

                return "{$targetTableAlias}.deleted_at IS NULL";
            }
        }

        return '';
    }
}