<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Doctrine\EventSubscriber;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Utils\CalculDegressive;
use CpCreation\VitiCore\Cart\Model\Cart;
use CpCreation\VitiCore\Cart\Model\Promo;
use CpCreation\VitiCore\Product\Model\ProductPriceCode;
use CpCreation\VitiCore\Product\Model\ProductTax;
use Doctrine\Common\EventSubscriber;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Events;
use Symfony\Component\HttpFoundation\RequestStack;

class CartSubscriber implements EventSubscriber
{
    private $requestStack;

    private $calculDegressive;

    public function __construct(RequestStack $requestStack, CalculDegressive $calculDegressive)
    {
        $this->requestStack     = $requestStack;
        $this->calculDegressive = $calculDegressive;
    }

    public function getSubscribedEvents()
    {

        return [
            Events::prePersist,
            Events::preUpdate,
            Events::postPersist,
            Events::postUpdate,
        ];
    }

    /**
     * @param LifecycleEventArgs $event
     */
    public function prePersist(LifecycleEventArgs $event)
    {
        $entity        = $event->getObject();
        $entityManager = $event->getEntityManager();
        if ($entity instanceof Cart) {
            $taxDefault = $entityManager->getRepository(ProductTax::class)->findOneBy(['byDefault' => true]);
            if (!$entity->getDeliveryAddress()->isDifferentAddress()) {
                $invoiceAddress = $entity->getInvoiceAddress();
                $entity->getDeliveryAddress()->setCompany($invoiceAddress->getCompany());
                $entity->getDeliveryAddress()->setPostalCode($invoiceAddress->getPostalCode());
                $entity->getDeliveryAddress()->setLastname($invoiceAddress->getLastname());
                $entity->getDeliveryAddress()->setFirstname($invoiceAddress->getFirstname());
                $entity->getDeliveryAddress()->setCity($invoiceAddress->getCity());
                $entity->getDeliveryAddress()->setCountry($invoiceAddress->getCountry());
                $entity->getDeliveryAddress()->setStreet($invoiceAddress->getStreet());
            }
            if ($this->requestStack->getCurrentRequest()->cookies->has('PRICE')) {
                $priceCode = $entityManager->getRepository(ProductPriceCode::class)->findOneBy(['id' => $this->requestStack->getCurrentRequest()->cookies->get('PRICE')]);
                if ($priceCode->getGroup()->isViewHT()) {
                    $entity->setViewHT(true);
                    $entity->setGroupCode($priceCode->getCode());
                    $entity->setTax($taxDefault->getValue());
                }
            }
        }
    }

    /**
     * @param LifecycleEventArgs $event
     */
    public function preUpdate(LifecycleEventArgs $event)
    {
        $entity        = $event->getObject();
        $entityManager = $event->getEntityManager();
        if ($entity instanceof Cart) {
            $taxDefault = $entityManager->getRepository(ProductTax::class)->findOneBy(['byDefault' => true]);
            if (!$entity->getDeliveryAddress()->isDifferentAddress()) {
                $invoiceAddress = $entity->getInvoiceAddress();
                $entity->getDeliveryAddress()->setCompany($invoiceAddress->getCompany());
                $entity->getDeliveryAddress()->setPostalCode($invoiceAddress->getPostalCode());
                $entity->getDeliveryAddress()->setLastname($invoiceAddress->getLastname());
                $entity->getDeliveryAddress()->setFirstname($invoiceAddress->getFirstname());
                $entity->getDeliveryAddress()->setCity($invoiceAddress->getCity());
                $entity->getDeliveryAddress()->setCountry($invoiceAddress->getCountry());
                $entity->getDeliveryAddress()->setStreet($invoiceAddress->getStreet());
            }
            if ($this->requestStack->getCurrentRequest()->cookies->has('PRICE')) {
                $priceCode = $entityManager->getRepository(ProductPriceCode::class)->findOneBy(['id' => $this->requestStack->getCurrentRequest()->cookies->get('PRICE')]);
                if ($priceCode->getGroup()->isViewHT()) {
                    $entity->setViewHT(true);
                    $entity->setGroupCode($priceCode->getCode());
                    $entity->setTax($taxDefault->getValue());
                }
            }
        }
    }

    /**
     * @param LifecycleEventArgs $event
     * @throws \Doctrine\ORM\NonUniqueResultException
     * @throws \Exception
     */
    public function postPersist(LifecycleEventArgs $event)
    {
        $entity = $event->getObject();
        if ($entity instanceof Cart) {
            $entityManager = $event->getEntityManager();
            $entity        = $this->calcul($entityManager, $entity);
            $om            = $event->getObjectManager();
            $om->persist($entity);
            $om->flush();
        }
    }

    /**
     * @param LifecycleEventArgs $event
     * @throws \Doctrine\ORM\NonUniqueResultException
     * @throws \Exception
     */
    public function postUpdate(LifecycleEventArgs $event)
    {
        $entity = $event->getObject();
        if ($entity instanceof Cart) {
            $entityManager = $event->getEntityManager();
            $entity        = $this->calcul($entityManager, $entity);
            $om            = $event->getObjectManager();
            $om->persist($entity);
            $om->flush();
        }
    }

    /**
     * @param EntityManager $entityManager
     * @param Cart          $entity
     * @return Cart
     * @throws \Doctrine\ORM\NonUniqueResultException
     * @throws \Exception
     */
    private function calcul(EntityManager $entityManager, Cart $entity)
    {
        /** @var Promo $promo */
        $promo = $entityManager->getRepository(Promo::class)->findPromoActivWithCode($entity->getPromo());

        if ($promo) {
            if ($promo->getAmount()) {
                $entity->setPromoValueAmount($promo->getAmount());
            }
            if ($promo->getPercent()) {
                $entity->setPromoValuePercent($promo->getPercent());
            }
        } else {
            $entity->setPromoValueAmount(null);
            $entity->setPromoValuePercent(null);
        }

        $degressiveTotal = $this->calculDegressive->calcul($entity);
        if ($degressiveTotal > 0) {
            $entity->setDegressiveValue($degressiveTotal);
        }

        return $entity;
    }
}
