<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Doctrine\EventSubscriber;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Utils\Mailer;
use CpCreation\VitiCore\Cart\Model\CartCheckout;
use CpCreation\VitiCore\Cart\Model\Promo;
use CpCreation\VitiCore\Contact\Model\Contact;
use Doctrine\Common\EventSubscriber;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Events;
use Symfony\Component\HttpFoundation\RequestStack;

class CartCheckoutSubscriber implements EventSubscriber
{
    private $request;
    private $mailer;

    /**
     * CartCheckoutSubscriber constructor.
     * @param RequestStack           $request
     * @param Mailer                 $mailer
     */
    public function __construct(RequestStack $request, Mailer $mailer)
    {
        $this->request = $request;
        $this->mailer  = $mailer;
    }

    public function getSubscribedEvents()
    {

        return [
            Events::prePersist,
            Events::postUpdate,
        ];
    }

    /**
     * @param LifecycleEventArgs $event
     */
    public function prePersist(LifecycleEventArgs $event)
    {
        $entity = $event->getObject();
        if ($entity instanceof CartCheckout) {
            $entity->setLocale($this->request->getCurrentRequest()->getLocale());
        }
    }

    /**
     * @param LifecycleEventArgs $event
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     */
    public function postUpdate(LifecycleEventArgs $event)
    {
        $entity = $event->getObject();
        $em     = $event->getEntityManager();
        if ($entity instanceof CartCheckout) {
            if ($entity->getPayedAt()) {
                $promoText = $entity->getCart()->getPromo();
                /** @var Promo $promo */
                $promo = $em->getRepository(Promo::class)->findOneBy(['title' => $promoText]);
                if ($promo) {
                    $promo->incrementCount();
                    $em->persist($promo);
                    $em->flush();
                }
            }
            if ($entity->isDelivery()) {
                $contact = $em->getRepository(Contact::class)->findOne();
                $this->mailer->senDelivery($contact, $entity->getCart());
            }
        }
    }

}