<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Behavior\Impl;

use CpCreation\VitiCore\Media\Model\File;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

/**
 * @ORM\HasLifecycleCallbacks()
 *
 */
trait Files
{
    /**
     * @ORM\ManyToMany(targetEntity="CpCreation\VitiCore\Media\Model\File")
     *
     * @var Collection<File>
     */
    private $files;

    public function addFile(File $file): void
    {
        $this->files[] = $file;
    }

    public function removeFile(File $file)
    {
        $this->files->removeElement($file);
    }

    /**
     * @return Collection<File>
     */
    public function getFiles(): Collection
    {
        return $this->files;
    }

    /**
     * @ORM\PrePersist()
     */
    public function generateFileCollectionIfEmpty()
    {
        if (null === $this->files) {
            $this->files = new ArrayCollection();
        }
    }
}