<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Behavior\Impl;

use Doctrine\ORM\Mapping as ORM;
use CpCreation\VitiCore\Media\Model\File as ModelFile;

trait File
{
    /**
     * @ORM\OneToOne(targetEntity="CpCreation\VitiCore\Media\Model\File", cascade={"persist", "remove"})
     * @ORM\JoinColumn(name="file_id", nullable=true, referencedColumnName="id", onDelete="SET NULL")
     * @var ModelFile
     */
    private $file;

    /**
     * @return ModelFile|null
     */
    public function getFile(): ?ModelFile
    {
        return $this->file;
    }

    /**
     * @param ModelFile|null $file
     */
    public function setFile(ModelFile $file = null)
    {
        if ($file->getPath() || $file->getFile()) {
            $this->file = $file;
        } else {
            $this->file = null;
        }
    }
}
