<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Season\Model\Translation;

use CpCreation\VitiCore\Behavior\Impl\Translation;
use Doctrine\ORM\Mapping as ORM;
use Knp\DoctrineBehaviors\Contract\Entity\TranslationInterface;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;
use Symfony\Component\Validator\Constraints as Assert;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * Class SeasonTranslation
 *
 * @ORM\Entity()
 * @ORM\Table(name="season_season_translation")
 * @ORM\HasLifecycleCallbacks()
 */
class SeasonTranslation implements TranslationInterface
{
    use Translation;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private $id;
    
    /**
     * @ORM\Column(type="text")
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $title;

    /**
     * @ORM\Column(type="text")
     * @Gedmo\Slug(fields={"title"})
     *
     * @var string
     */
    private $slug;

    /**
     * @ORM\Column(type="text")
     *
     * @var string
     */
    private $subtitle;

    /**
     * @ORM\Column(type="text")
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $firstText;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string
     */
    private $secondText;

    public function __construct()
    {
        $this->id       = Uuid::uuid4();
    }
    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }
    
    /**
     * @return string
     */
    public function getTitle(): ?string
    {
        return $this->title;
    }

    /**
     * @param string $title
     */
    public function setTitle(string $title = null)
    {
        $this->title = $title;
    }

    /**
     * @return string
     */
    public function getSlug(): string
    {
        return $this->slug;
    }

    /**
     * @param string $slug
     */
    public function setSlug(string $slug)
    {
        $this->slug = $slug;
    }

    /**
     * @return string
     */
    public function getSubtitle(): ?string
    {
        return $this->subtitle;
    }

    /**
     * @param string $subtitle
     */
    public function setSubtitle(string $subtitle = null)
    {
        $this->subtitle = $subtitle;
    }

    /**
     * @return string
     */
    public function getFirstText(): ?string
    {
        return $this->firstText;
    }

    /**
     * @param string $firstText
     */
    public function setFirstText(string $firstText = null)
    {
        $this->firstText = $firstText;
    }

    /**
     * @return string
     */
    public function getSecondText(): ?string
    {
        return $this->secondText;
    }

    /**
     * @param string $secondText
     */
    public function setSecondText(string $secondText = null)
    {
        $this->secondText = $secondText;
    }
}
