<?php
/**
 * @author Colinet Julien
 */
namespace CpCreation\VitiCore\Contact\Repository;

use CpCreation\VitiCore\Contact\Model\Contact;
use CpCreation\VitiCore\Repository\BaseRepository;
use Doctrine\Persistence\ManagerRegistry;

class ContactRepository extends BaseRepository
{
    /**
     * ContactRepository constructor.
     * @param ManagerRegistry $registry
     * @throws \ReflectionException
     */
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Contact::class);
    }

    /**
     * @return mixed
     * @throws \Doctrine\ORM\NoResultException
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function findReCaptchaKeyPrivate()
    {
        $qb = $this
            ->createQueryBuilder('contact')
            ->select('contact.recaptchaKeyPrivate')
            ->getQuery()
            ->getSingleScalarResult();

        return $qb;
    }

    /**
     * @return mixed
     * @throws \Doctrine\ORM\NoResultException
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function findReCaptchaKeyPublic()
    {
        $qb = $this
            ->createQueryBuilder('contact')
            ->select('contact.recaptchaKeyPublic')
            ->getQuery()
            ->getSingleScalarResult();

        return $qb;
    }
}