<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use A2lix\TranslationFormBundle\Form\Type\TranslationsType;
use CpCreation\VitiCore\Season\Model\Season;
use CpCreation\VitiCore\Season\Model\SeasonImage;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class SeasonType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'translations', TranslationsType::class, [
                    'label'  => false,
                    'fields' => [
                        'title'      => [
                            'field_type' => TextType::class,
                            'label'      => 'Titre',
                            'required'   => false,
                        ],
                        'subtitle'   => [
                            'field_type' => TextType::class,
                            'label'      => 'Sous-titre',
                            'required'   => false,
                        ],
                        'firstText'  => [
                            'field_type' => TrumbowygType::class,
                            'label'      => 'Premier Texte',
                            'required'   => true,
                        ],
                        'secondText' => [
                            'field_type' => TrumbowygType::class,
                            'label'      => 'Second Texte',
                            'required'   => false,
                        ],
                    ],
                    'excluded_fields' => ['slug']
                ]
            )
            ->add(
                'images', ImageCollectionType::class, [
                    'label'          => false,
                    'entry_type'     => SeasonImageType::class,
                    'allow_add'      => true,
                    'allow_delete'   => true,
                    'error_bubbling' => false,
                    'prototype'      => true,
                    'by_reference'   => false,
                    'delete_empty'   => true,
                    'attr'           => [
                        'data-name-prefix' => 'Image',
                        'class'            => "image-collection",
                    ],
                    'entry_options'  => [
                        'data_class' => SeasonImage::class,
                        'label'      => false,
                    ],
                ]
            )
            ->add(
                'video', VideoType::class, [
                    'label'    => false,
                    'required' => false,
                ]
            )
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                "data_class" => Season::class,
            ]
        );
    }
}