<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\Payment;


use CpCreation\VitiCore\Cart\Model\Payment\Sherlock;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\DataTransformerInterface;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;
use Symfony\Component\Serializer\Serializer;

class SherlockPaymentType extends AbstractType implements PaymentMethodInterface, DataTransformerInterface
{
    const TYPE = 'sherlock';

    private $serializer;

    public function __construct()
    {
        $normalizers = [new ObjectNormalizer()];
        $this->serializer = new Serializer($normalizers);
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class,[
                'label' => 'Nom',
                'required'    => true
            ])
            ->add('debug', CheckboxType::class,[
                'label' => 'Debug',
                'required'    => false
            ])
            ->add('certif', TextareaType::class, [
                'label'       => 'Certificat Client',
                'required'    => true,
                'attr' => [
                    'rows' => 12
                ]
            ]);
        $builder->addModelTransformer($this);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Sherlock::class
        ]);
    }

    public function transform($data)
    {
        return $this->serializer->denormalize($data, Sherlock::class);
    }

    public function reverseTransform($data)
    {
        return $this->serializer->normalize($data);
    }

    public function getMethod()
    {
        return static::TYPE;
    }

    public function getBlockPrefix()
    {
        return 'sherlock_cb_payment';
    }
}
