<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Client\InstagramClient;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Provider\SocialNetwork\BasicInstagramProvider;
use CpCreation\VitiCore\SocialNetwork\Model\SocialNetworkNew;
use CpCreation\VitiCore\SocialNetwork\Repository\SocialNetworkNewRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_SOCIAL')")
 * Class SocialNetworkNewController
 *
 * @package CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin
 * @Route("/social-network-new")
 */
class SocialNetworkNewController extends AbstractController
{
    private $basicInstagramProvider;
    private $instagramClient;
    private $socialNetworkNewRepository;

    /**
     * SocialNetworkNewController constructor.
     * @param BasicInstagramProvider $basicInstagramProvider
     * @param InstagramClient        $instagramClient
     */
    public function __construct(BasicInstagramProvider $basicInstagramProvider,
        InstagramClient $instagramClient,
        SocialNetworkNewRepository $socialNetworkNewRepository
    ) {
        $this->basicInstagramProvider     = $basicInstagramProvider;
        $this->instagramClient            = $instagramClient;
        $this->socialNetworkNewRepository = $socialNetworkNewRepository;
    }

    /**
     * @Route("", name="admin_socialNew")
     * @Template("@CpCreationVitiCore/admin/socialNew/index.html.twig")
     *
     * @return array
     */
    public function indexAction(Request $request)
    {
        $connectId     = $request->query->get('connectId', null);
        $username      = $request->query->get('username', null);
        $result        = $request->query->get('result', null);
        $type          = $request->query->get('type', null);
        $socialNetwork = null;
        $errorCode     = null;
        $errorMessage  = null;
        if (!$result) {
            $socialNetwork = $this->socialNetworkNewRepository->findByLikeSocial('instagram');
        } else {
            if ($result === "success") {
                $socialNetwork = $this->socialNetworkNewRepository->findByConnectId($connectId);
                if (!$socialNetwork) {
                    $socialNetwork = new SocialNetworkNew();
                }
                $socialNetwork->setConnectId($connectId);
                $socialNetwork->setUsername($username);
                $socialNetwork->setNetwork($type);
                $this->socialNetworkNewRepository->save($socialNetwork);
            } else {
                $errorCode    = $request->query->get('error_code', null);
                $errorMessage = $request->query->get('error_message', null);
            }
        }

        return [
            "socialNetwork" => $socialNetwork,
            "errorCode"     => $errorCode,
            "errorMessage"  => $errorMessage,
            "result"        => $result,
        ];
    }

    /**
     * @Route("/{id}/delete", name="admin_socialNew_delete")
     *
     * @param SocialNetworkNew $socialNetworkNew
     */
    public function deleteTokeninstagram(SocialNetworkNew $socialNetworkNew)
    {
        $this->socialNetworkNewRepository->removeInstagram($socialNetworkNew);
        $this->addFlash('alert-success', 'Votre compte instagram a bien été supprimé de nos bases de données');

        return $this->redirectToRoute('admin_socialNew');
    }

    /**
     * @Route("/{id}/refresh", name="admin_socialNew_refresh")
     *
     * @param SocialNetworkNew $socialNetworkNew
     */
    public function refreshTokeninstagram(SocialNetworkNew $socialNetworkNew)
    {
        $this->socialNetworkNewRepository->removeInstagram($socialNetworkNew);
        $this->addFlash('alert-success', 'Votre compte instagram a bien été supprimé de nos bases de données');

        return $this->redirectToRoute('admin_socialNew');
    }

    /**
     * @param Request $request
     * @Route("/instagram/login", name="admin_socialNew_instagram_login")
     *
     * @return RedirectResponse
     */
    public function instagramLoginAction(Request $request)
    {
        return new RedirectResponse($this->basicInstagramProvider->loginUrl($request));
    }

}
