<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin;

use CpCreation\VitiCore\Payment\Repository\PaymentRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

/**
 * @Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_PAYMENT_PAYMENT')")
 * Class PaymentController
 *
 * @Route("/payment")
 */
class PaymentController extends AbstractController
{
    private $paymentRepository;

    public function __construct(
        PaymentRepository $paymentRepository
    ) {
        $this->paymentRepository = $paymentRepository;
    }

    /**
     * @Route("", name="admin_payment_payment")
     * @Template("@CpCreationVitiCore/admin/payment/index.html.twig")
     */
    public function indexAction()
    {
        $orders = $this->paymentRepository->findByCreatedAdminAt('DESC');

        return [
            "items" => $orders,
        ];
    }

}
