<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Shop\Repository;

use CpCreation\VitiCore\Product\Model\ProductPriceGroup;
use CpCreation\VitiCore\Repository\BaseRepository;
use CpCreation\VitiCore\Shop\Model\ShippingAdditional;
use Doctrine\ORM\Query\Expr\Join;
use Doctrine\Persistence\ManagerRegistry;

class ShippingAdditionalRepository extends BaseRepository
{
    /**
     * ShippingAdditionalRepository constructor.
     * @param ManagerRegistry $registry
     * @throws \ReflectionException
     */
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, ShippingAdditional::class);
    }

    /**
     * @param int               $qty
     * @param string            $county
     * @param ProductPriceGroup $group
     *
     * @return mixed
     */
    public function findByQuantityAndByCountyAndByGroup(int $qty, string $county, $group)
    {
        $datetime = new \DateTime();
        $dateInt = date("nd", $datetime->getTimestamp());
        $qb = $this
            ->createQueryBuilder('a')
            ->innerJoin('a.groups','g',Join::WITH,'g.id = :group')
            ->innerJoin('a.counties', 'counties', Join::WITH, 'counties.code = :county')
            ->andwhere('a.qtyOf < :qty')
            ->andwhere('a.qtyAt >= :qty')
            ->andwhere('a.dateOf <= :dateInt')
            ->andwhere('a.dateAt >= :dateInt')
            ->setParameter('dateInt', $dateInt)
            ->setParameter('qty', $qty)
            ->setParameter('county', $county)
            ->setParameter('group', $group)
            ->getQuery()
            ->getResult()
            ;

        return $qb;
    }
}
