<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Shop\Repository;

use CpCreation\VitiCore\Repository\BaseRepository;
use CpCreation\VitiCore\Shop\Model\DeliveryMethod;
use Doctrine\ORM\Query\Expr\Join;
use Doctrine\Persistence\ManagerRegistry;

class DeliveryMethodRepository extends BaseRepository
{
    /**
     * DeliveryMethodRepository constructor.
     * @param ManagerRegistry $registry
     * @throws \ReflectionException
     */
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, DeliveryMethod::class);
    }

    /**
     * @param null $groupId
     * @return \Doctrine\ORM\QueryBuilder
     */
    public function findPublishQueryBuilder($groupId = null)
    {
        $qb = $this
            ->createQueryBuilder('dm')
            ->innerJoin('dm.category','category')
            ->andWhere('dm.publishedAt <= :datetime ')
            ->andWhere('dm.unPublishedAt >= :datetime OR dm.unPublishedAt is NULL')
            ->andWhere('dm.disabled = false')
            ->andWhere('dm.deletedAt is NULL')
            ->andWhere('category.disabled = false')
            ->addOrderBy('category.position', 'ASC')
            ->addOrderBy('dm.position', 'ASC')
            ->setParameter('datetime', new \DateTime('now'));
        if ($groupId) {
            $qb
                ->join('dm.groups', 'groups', Join::WITH, 'groups.id = :groupId')
                ->setParameter('groupId', $groupId);
        }


        return $qb;
    }

    /**
     * @param $county | Code du département (2 chiffres)
     * @return mixed
     */
    public function findPublishByCountyByCategory($county)
    {
        $qb = $this
            ->createQueryBuilder('dm')
            ->andWhere('dm.publishedAt <= :datetime ')
            ->andWhere('dm.unPublishedAt >= :datetime')
            ->andWhere('dm.disabled = false')
            ->andWhere('dm.deletedAt is NULL')
            ->innerJoin('dm.category', 'category')
            ->innerJoin('dm.counties', 'counties', Join::WITH, 'counties.code = :county')
            ->orderBy('category.position', 'ASC')
            ->orderBy('dm.position', 'ASC')
            ->setParameter('datetime', new \DateTime('now'))
            ->setParameter('county', $county)
            ->getQuery()
            ->getResult();

        return $qb;
    }

}
