<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Shop\Model;

use CpCreation\VitiCore\Behavior\HasDisable;
use CpCreation\VitiCore\Behavior\HasTranslatable;
use CpCreation\VitiCore\Behavior\Impl\Disable;
use CpCreation\VitiCore\Behavior\Impl\Translatable;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;
use Gedmo\Mapping\Annotation as Gedmo;
use Ramsey\Uuid\UuidInterface;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Validator\Context\ExecutionContextInterface;

/**
 * Class DeliveryMethodCategory
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Shop\Repository\DeliveryMethodCategoryRepository")
 * @ORM\Table(name="shop_delivery_method_category")
 * @ORM\HasLifecycleCallbacks()
 */
class DeliveryMethodCategory implements HasTranslatable, HasDisable
{
    use Translatable, Disable;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private $id;

    /**
     * @ORM\Column(type="integer")
     * @Gedmo\SortablePosition()
     *
     * @var integer
     */
    private $position;


    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $minView;

    /**
     * @ORM\Column(type="boolean", options={"default": false})
     *
     * @var bool
     */
    private $disabledShippingAddress = false;

    /**
     * @ORM\OneToMany(targetEntity="DeliveryMethod", mappedBy="category", orphanRemoval=true)
     * @ORM\JoinColumn(name="method_category_id", referencedColumnName="id", nullable=true)
     * @ORM\OrderBy({"position" = "ASC"})
     * @var Collection | DeliveryMethod[]
     */
    private $methods;

    /**
     * DeliveryMethod constructor.
     * @throws \Exception
     */
    public function __construct()
    {
        $this->id       = Uuid::uuid4();
        $this->disabled = false;
        $this->methods  = new ArrayCollection();
        $this->minView  = false;
    }

    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }

    /**
     * @return int
     */
    public function getPosition(): ?int
    {
        return $this->position;
    }

    /**
     * @param int $position
     */
    public function setPosition(int $position)
    {
        $this->position = $position;
    }

    /**
     * @return bool
     */
    public function isMinView(): bool
    {
        return $this->minView;
    }

    /**
     * @param bool $minView
     */
    public function setMinView(bool $minView): void
    {
        $this->minView = $minView;
    }

    public function isDisabledShippingAddress(): bool
    {
        return $this->disabledShippingAddress;
    }

    public function setDisabledShippingAddress(bool $disabledShippingAddress): void
    {
        $this->disabledShippingAddress = $disabledShippingAddress;
    }
    
    /**
     * @return Collection
     */
    public function getMethods(): ?Collection
    {
        return $this->methods;
    }

    /**
     * @param \Symfony\Component\Validator\Context\ExecutionContextInterface $context
     * @Assert\Callback()
     */
    public function validate(ExecutionContextInterface $context)
    {
        if ($this->isMinView()) {
            if (!$this->getMinViewTextClose() || !$this->getMinViewTextOpen())
            {
                $message = 'This value should not be blank.';
                $context->buildViolation($message)
                        ->atPath("translations['fr'].minViewTextOpen")
                        ->addViolation();
                $context->buildViolation($message)
                        ->atPath("translations['fr'].minViewTextClose")
                        ->addViolation();
            }
        }
    }
}
