<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Product\Repository;

use CpCreation\VitiCore\Behavior\IsSoftDeletable;
use CpCreation\VitiCore\Product\Model\ProductPriceCode;
use CpCreation\VitiCore\Repository\BaseRepository;
use Doctrine\Persistence\ManagerRegistry;

class ProductPriceCodeRepository extends BaseRepository
{
    /**
     * ProductPriceCodeRepository constructor.
     * @param ManagerRegistry $registry
     * @throws \ReflectionException
     */
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, ProductPriceCode::class);
    }

    public function findByGroupOrderAdmin()
    {
        $qb    = $this->createQueryBuilder('r')
                      ->orderBy('r.group', 'ASC');
        $qb->andWhere('r.deletedAt is NULL');

        $query = $qb->getQuery();

        return $query->execute();
    }

    /**
     * @param $code
     * @return int|mixed|string|null
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function findOneCode($code)
    {
        $qb    = $this->createQueryBuilder('r')
                      ->andWhere('r.code = :code')
                      ->setParameter('code', $code);
        $qb->andWhere('r.deletedAt is NULL');
        $qb->andWhere('r.disabled = false');

        $query = $qb->getQuery();

        return $query->getOneOrNullResult();
    }

    /**
     * @param $code
     * @return int|mixed|string|null
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function findOneViewHt($code)
    {
        $qb    = $this->createQueryBuilder('r')
                      ->andWhere('r. = tue')
                      ->andWhere('r.code = :code')
                      ->setParameter('code', $code);
        $qb->andWhere('r.deletedAt is NULL');

        $query = $qb->getQuery();

        return $query->getOneOrNullResult();
    }
}
