<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Product\Model\Translation;

use CpCreation\VitiCore\Behavior\Impl\Translation;
use Doctrine\ORM\Mapping as ORM;
use Knp\DoctrineBehaviors\Contract\Entity\TranslatableInterface;
use Knp\DoctrineBehaviors\Contract\Entity\TranslationInterface;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;
use Symfony\Component\Validator\Constraints as Assert;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * Class ProductTypeTranslation
 *
 * @ORM\Entity()
 * @ORM\Table(name="product_type_translation")
 */
class ProductTypeTranslation implements TranslationInterface
{
    use Translation;

    /**
     * L'évènement LoadClassMetaData de TransaltableEventsubscriber ne se lance pas pour ProductTypeTranslation ( Nous n'avons pas trouvé pourquoi .. ). C'est pour cela que nous inscrivons la relation en annotation
     * @ORM\ManyToOne(targetEntity="CpCreation\VitiCore\Product\Model\ProductType", inversedBy="translations", cascade={"persist","merge"})
     * @ORM\JoinColumn(name="translatable_id", referencedColumnName="id", onDelete="CASCADE")
     * 
     * @var TranslatableInterface
     */
    protected $translatable;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private $id;

    /**
     * @ORM\Column(type="text")
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $name;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string
     */
    private $info;

    /**
     * @ORM\Column(type="text")
     * @Gedmo\Slug(fields={"name","info"})
     *
     * @var string
     */
    private $slug;

    public function __construct()
    {
        $this->id       = Uuid::uuid4();
    }
    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }
    
    /**
     * @return string
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name = null): void
    {
        $this->name = $name;
    }

    /**
     * @return string|null
     */
    public function getInfo(): ?string
    {
        return $this->info;
    }

    /**
     * @param string|null $info
     */
    public function setInfo(?string $info): void
    {
        $this->info = $info;
    }


    /**
     * @return string
     */
    public function getSlug(): ?string
    {
        return $this->slug;
    }

    /**
     * @param string $slug
     */
    public function setSlug(string $slug = null): void
    {
        $this->slug = $slug;
    }
}
