<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Product\Model;

use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\Impl\SoftDeletable;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use CpCreation\VitiCore\Behavior\IsSoftDeletable;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class ProductPrice
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Product\Repository\ProductPriceRepository")
 * @ORM\Table(name="product_price")
 * @ORM\HasLifecycleCallbacks()
 */
class ProductPrice implements HasTimestamp, IsSoftDeletable
{
    use Timestamp, SoftDeletable;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private $id;

    /**
     * @ORM\Column(type="integer")
     * @Assert\NotBlank()
     *
     * @var integer
     */
    private $price;

    /**
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var integer
     */
    private $priceDiscount;

    /**
     * @ORM\ManyToOne(targetEntity="ProductPriceGroup", inversedBy="prices")
     * @Assert\NotBlank()
     *
     * @var ProductPriceGroup
     */
    private $group;

    /**
     * @ORM\ManyToOne(targetEntity="ProductVariant", inversedBy="prices")
     * @ORM\JoinColumn(name="variant_id", referencedColumnName="id")
     *
     * @var ProductVariant
     */
    private $variant;

    public function __construct()
    {
        $this->id = Uuid::uuid4();
    }

    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }

    /**
     * @return int
     */
    public function getPrice(): ?int
    {
        return $this->price;
    }

    /**
     * @param int $price
     */
    public function setPrice(int $price = null): void
    {
        $this->price = $price;
    }

    /**
     * @return int
     */
    public function getPriceDiscount(): ?int
    {
        return $this->priceDiscount;
    }

    /**
     * @param int $priceDiscount
     */
    public function setPriceDiscount(int $priceDiscount = null): void
    {
        $this->priceDiscount = $priceDiscount;
    }

    /**
     * @return ProductPriceGroup
     */
    public function getGroup(): ?ProductPriceGroup
    {
        return $this->group;
    }

    /**
     * @param ProductPriceGroup $group
     */
    public function setGroup(ProductPriceGroup $group = null): void
    {
        $this->group = $group;
    }

    /**
     * @return ProductVariant
     */
    public function getVariant(): ?ProductVariant
    {
        return $this->variant;
    }

    /**
     * @param ProductVariant $variant
     */
    public function setVariant(ProductVariant $variant = null): void
    {
        $this->variant = $variant;
    }
}
