<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\News\Repository;

use CpCreation\VitiCore\News\Model\Category;
use CpCreation\VitiCore\Repository\BaseRepository;
use Doctrine\Persistence\ManagerRegistry;

class CategoryRepository extends BaseRepository
{

    /**
     * CategoryRepository constructor.
     * @param ManagerRegistry $registry
     * @throws \ReflectionException
     */
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Category::class);
    }

    public function findCategories()
    {
        $date = new \DateTime('now');
        $qb = $this
            ->createQueryBuilder('cat')
            ->innerJoin('cat.news', 'n')
            ->where('n.unPublishedAt >= :date OR n.unPublishedAt IS NULL')
            ->andWhere('n.publishedAt <= :date OR n.publishedAt IS NULL')
            ->andWhere('n.disabled = FALSE')
            ->addOrderBy('cat.position', 'ASC')
            ->addOrderBy('n.eventAt', 'DESC')
            ->setParameter('date', $date)
            ->getQuery();

        return $qb->execute();
    }

}
