<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Depot\Model;

use CpCreation\VitiCore\Behavior\HasDisable;
use CpCreation\VitiCore\Behavior\HasGeocoder;
use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\HasTranslatable;
use CpCreation\VitiCore\Behavior\Impl\Disable;
use CpCreation\VitiCore\Behavior\Impl\Geocodable;
use CpCreation\VitiCore\Behavior\Impl\SoftDeletable;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use CpCreation\VitiCore\Behavior\Impl\Translatable;
use CpCreation\VitiCore\Behavior\IsSoftDeletable;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;
use Symfony\Component\Validator\Constraints as Assert;
use Gedmo\Mapping\Annotation as Gedmo;


/**
 * Class Depot
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Depot\Repository\DepotRepository")
 * @ORM\Table(name="depot_depot")
 * @ORM\HasLifecycleCallbacks()
 */
class Depot implements HasTimestamp, HasDisable, IsSoftDeletable, HasTranslatable, HasGeocoder
{
    use Timestamp, Disable, SoftDeletable, Translatable, Geocodable;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private $id;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string
     */
    private $phone;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Assert\Url()
     *
     * @var string
     */
    private $website;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Assert\Email()
     *
     * @var string
     */
    private $email;

    /**
     * @Gedmo\SortablePosition()
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var int|null
     */
    private $position;

    /**
     * @ORM\ManyToOne(targetEntity="Category", inversedBy="depots")
     * @ORM\JoinColumn(name="depot_category_id", referencedColumnName="id", nullable=true, onDelete="CASCADE")
     * @Gedmo\SortableGroup()
     *
     * @var Category
     */
    private $category;


    public function __construct()
    {
        $this->id = Uuid::uuid4();
        $this->disabled = false;
    }

    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getPhone(): ?string
    {
        return $this->phone;
    }

    /**
     * @param string $phone
     */
    public function setPhone(?string $phone)
    {
        $this->phone = $phone;
    }

    /**
     * @return string
     */
    public function getWebsite(): ?string
    {
        return $this->website;
    }

    /**
     * @param string $website
     */
    public function setWebsite(string $website = null)
    {
        $this->website = $website;
    }

    /**
     * @return string
     */
    public function getEmail(): ?string
    {
        return $this->email;
    }

    /**
     * @param string $email
     */
    public function setEmail(string $email = null)
    {
        $this->email = $email;
    }

    /**
     * @return int
     */
    public function getPosition(): ?int
    {
        return $this->position;
    }

    /**
     * @param int $position
     */
    public function setPosition(?int $position): void
    {
        $this->position = $position;
    }

    /**
     * @return Category
     */
    public function getCategory(): ?Category
    {
        return $this->category;
    }

    /**
     * @param Category $category
     */
    public function setCategory(Category $category = null)
    {
        $this->category = $category;
    }
}
