<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Provider\Carrier;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Filesystem\FileFilesystem;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Utils\CheckCity;
use CpCreation\VitiCore\Shop\Model\ShippingAuto;
use CpCreation\VitiCore\Shop\Model\ShippingAutoSup;
use CpCreation\VitiCore\Shop\Model\ShippingConfig;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\RequestStack;

class Genin2023Provider implements CarrierProviderInterface
{
    const TYPE = 'genin_2023';

    /**
     * @var FileFilesystem
     */
    private $filesystem;

    /**
     * @var EntityManagerInterface
     */
    private $em;

    /**
     * @var CheckCity
     */
    private $checkCity;

    /**
     * @var RequestStack
     */
    private $requestStack;

    /**
     * @var array
     */
    private $pal;

    public function __construct(RequestStack $requestStack,
        FileFilesystem $filesystem,
        EntityManagerInterface $em,
        CheckCity $checkCity
    ) {
        $this->filesystem   = $filesystem;
        $this->em           = $em;
        $this->checkCity    = $checkCity;
        $this->requestStack = $requestStack;
        ## 1 palette comporte 504 bouteilles vu avec Anne-Lise ##
        $this->pal = [
            "1/4 de palette"              => "0 à 126",
            "1/2 palette"                 => "126 à 252",
            "1 palette 80x120 ou 100x120" => "252 à 504",
            "2 palettes 80x120"           => "504 à 1008",
            "3 palettes 80x120"           => "1008 à 1512",
            "4 palettes 80x120 "          => "1512 à 2016",
            "5 palettes 80x120"           => "2016 à 2520",
            "6 palettes 80x120"           => "2520 à 3024",
            "7 palettes 80x120"           => "3024 à 3528",
            "8 palettes 80x120"           => "3528 à 4032",
        ];
    }

    /**
     * @param ShippingConfig $config
     * @throws \Doctrine\DBAL\DBALException
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     * @throws \PhpOffice\PhpSpreadsheet\Reader\Exception
     * @throws \PhpOffice\PhpSpreadsheet\Writer\Exception
     */
    public function setData(ShippingConfig $config)
    {
        $files   = $this->requestStack->getCurrentRequest()->files->get('shipping_config');
        $file    = $files['file']['file'];
        $fileSup = $files['fileSup']['file'];
        $reader  = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        $reader->setReadDataOnly(true);
        if ($file) {
            $spreadsheet = $reader->load($this->filesystem->getAdapter()->getPathPrefix().$config->getFile()->getPath());
            $writer      = new \PhpOffice\PhpSpreadsheet\Writer\Csv($spreadsheet);
            $writer->save($this->filesystem->getAdapter()->getPathPrefix()."genin2023.csv");

            if (($handle = fopen($this->filesystem->getAdapter()->getPathPrefix()."genin2023.csv", "r")) !== false) {

                $classMetaData = $this->em->getClassMetadata(ShippingAuto::class);
                $connection    = $this->em->getConnection();
                $dbPlatform    = $connection->getDatabasePlatform();
                $connection->beginTransaction();
                $connection->query('SET FOREIGN_KEY_CHECKS=0');
                $q = $dbPlatform->getTruncateTableSql($classMetaData->getTableName());
                $connection->executeUpdate($q);
                $connection->query('SET FOREIGN_KEY_CHECKS=1');

                $row                   = 0;
                $shippingQtyCollection = [];
                while (($data = fgetcsv($handle, 2000, ",")) !== false) {
                    $num = count($data);
                    $row++;
                    for ($c = 0; $c < $num; $c++) {
                        if ($data[$c] === 'Délai de livraison') {
                            for ($c = $c + 1; $c < $num; $c++) {
                                if ($data[$c] != "") {
                                    foreach ($this->pal as $key => $pal) {
                                        if ($key == $data[$c]) {
                                            $explode                                = explode('à', $pal);
                                            $shippingQtyCollection[$data[$c]]['of'] = intval(trim($explode[0]));
                                            $shippingQtyCollection[$data[$c]]['at'] = intval(trim($explode[1]));
                                            $numMax                                 = $c;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if ($data[0] == "France") {
                        $department = $data[1];
                        if ($department != "0") {
                            foreach ($this->pal as $key => $pal) {
                                $shipping = new ShippingAuto();
                                $shipping->setCountry('FR');
                                $county = substr($department, 0, 2);
                                $shipping->setCounty($county);
                                $shipping->setQtyOf($shippingQtyCollection[$key]['of']);
                                $shipping->setQtyAt($shippingQtyCollection[$key]['at']);
                                $shipping->setPackagePrice(floatval($data[array_search($key, array_keys($this->pal)) + 3]) * 100);
                                $this->em->persist($shipping);
                            }
                        }
                    }
                }
                $this->em->flush();
                fclose($handle);
                unset($handle);
                unset($data);
            }
        }
    }

    /**
     * @return string
     */
    public
    function getCarrier(): string
    {
        return static::TYPE;
    }
}
