<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\SocialNetwork;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\ConnectFacebookFacebookIdType;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\ConnectFacebookInstagramIdType;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\ConnectFacebookUserIdType;
use CpCreation\VitiCore\SocialNetwork\Model\Network\FacebookFacebook;
use CpCreation\VitiCore\SocialNetwork\Model\Network\FacebookInstagram;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\DataTransformerInterface;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;
use Symfony\Component\Serializer\Serializer;

class FacebookInstagramNetworkType extends AbstractType implements SocialNetworkNetworkInterface, DataTransformerInterface
{
    const TYPE = 'facebook_instagram';

    /**
     * @var Serializer
     */
    private $serializer;


    public function __construct()
    {
        $normalizers      = [new ObjectNormalizer()];
        $this->serializer = new Serializer($normalizers);
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'id', ConnectFacebookUserIdType::class, [
                    'label'    => 'Connect Client Social ID',
                    'required' => true,
                ]
            )
            ->add('accountInstagram', ConnectFacebookInstagramIdType::class)
            ->add('name', HiddenType::class);

        $builder->addEventListener(
            FormEvents::PRE_SUBMIT,
            [$this, 'onPreSubmit']
        );


        $builder->addModelTransformer($this);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => FacebookInstagram::class,
            ]
        );
    }

    public function onPreSubmit(FormEvent $event)
    {
        $form = $event->getForm();
        $data = $event->getData();
        $userId       = $form->getNormData()->getId();
        if ($userId) {
            foreach ($form->get('accountInstagram')->getConfig()->getOption('choices') as $key => $choice)
            {
                if ($choice == $data['accountInstagram'])
                {
                    $data['name'] = $key;
                }
            }
            $event->setData($data);
        }
    }

    public function transform($data)
    {

        return $this->serializer->denormalize($data, FacebookInstagram::class);
    }

    public function reverseTransform($data)
    {

        return $this->serializer->normalize($data);
    }

    public function getNetwork()
    {
        return static::TYPE;
    }

    public function getBlockPrefix()
    {
        return 'facebook_instagram_network';
    }
}