<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\SocialNetwork;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\ConnectBasicInstagramUserIdType;
use CpCreation\VitiCore\SocialNetwork\Model\Network\BasicInstagram;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\DataTransformerInterface;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;
use Symfony\Component\Serializer\Serializer;

class BasicInstagramNetworkType extends AbstractType implements SocialNetworkNetworkInterface, DataTransformerInterface
{
    const TYPE = 'basic_instagram';

    /**
     * @var Serializer
     */
    private $serializer;


    public function __construct()
    {
        $normalizers      = [new ObjectNormalizer()];
        $this->serializer = new Serializer($normalizers);
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'id', ConnectBasicInstagramUserIdType::class, [
                    'label'    => 'Connect Client Social ID',
                    'required' => true,
                ]
            );

        $builder->addModelTransformer($this);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => BasicInstagram::class,
            ]
        );
    }

    public function transform($data)
    {

        return $this->serializer->denormalize($data, BasicInstagram::class);
    }

    public function reverseTransform($data)
    {

        return $this->serializer->normalize($data);
    }

    public function getNetwork()
    {
        return static::TYPE;
    }

    public function getBlockPrefix()
    {
        return 'basic_instagram_network';
    }
}