<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use A2lix\TranslationFormBundle\Form\Type\TranslationsType;
use CpCreation\VitiCore\Shop\Model\ShippingConfig;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\MoneyType;
use Symfony\Component\Form\Extension\Core\Type\PercentType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Authorization\AuthorizationCheckerInterface;

class ShippingConfigType extends AbstractType
{
    /**
     * @var array
     */
    private $choices;

    /**
     * @var AuthorizationCheckerInterface
     */
    private $authorizationChecker;

    public function __construct(AuthorizationCheckerInterface $authorizationChecker, $carrierMethods = [])
    {
        foreach ($carrierMethods as $carrier) {
            $this->choices[$carrier] = $carrier;
        }
        $this->authorizationChecker = $authorizationChecker;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        if ($this->authorizationChecker->isGranted('ROLE_ADMIN')) {

            $builder
                ->add(
                    'marginManu', PercentType::class, [
                        'scale'    => 2,
                        'label'    => 'Marge Assurance (Ajouté à la fin sur le total du transport + total de la commande)',
                        'required' => false,
                    ]
                )
                ->add(
                    'marginClientManu', PercentType::class, [
                        'scale'    => 2,
                        'label'    => 'Marge ajouté par le client => Après Calcul frais de port',
                        'required' => false,
                    ]
                )
                ->add(
                    'tvaManu', PercentType::class, [
                        'scale'    => 2,
                        'label'    => 'TVA à ajouter aux frais de port manuel',
                        'required' => false,
                    ]
                )
                ->add(
                    'forceEquivalencyForAuto', CheckboxType::class, [
                        'label'    => 'Force les frais de port Auto si l\'équivalence totale de l\'ensemble de la commande (sans les accessoires) n\'a pas de correspondance avec l\'équivalence par défaut en mode Manuel ',
                        'required' => false,
                    ]
                )
                ->add(
                    'qtyEquivalencyBottle', integerType::class,
                    [
                        'label'    => 'Si l\'ensemble de la commande en équivalence bouteille (sans les accessoires) dépasse ce nombre, l\'ensemble de la commande passe en équivalence bouteille',
                        'required' => false,
                    ]
                )
                ->add(
                    'amountMinVDManu', MoneyType::class,
                    [
                        'divisor'  => 100,
                        'label'    => 'Minimum de perception Assurance (€ H.T)',
                        'required' => false,
                    ]
                )
                ->add(
                    'qtyMinVDManu', integerType::class,
                    [
                        'label'    => 'Minimum quantity (équivalence bouteille) pour activer la taxe valeur déclarée',
                        'required' => false,
                    ]
                )
                ->add(
                    'amountByBottleTTC', MoneyType::class,
                    [
                        'divisor'  => 100,
                        'label'    => 'Ajout montant par bouteille à la fin du calcul des frais de port Manu (€ TTC)',
                        'required' => false,
                    ]
                )
                ->add(
                    'amountAutoByBottleTTC', MoneyType::class,
                    [
                        'divisor'  => 100,
                        'label'    => 'Ajout montant par bouteille à la fin du calcul des frais de port Auto(€ TTC)',
                        'required' => false,
                    ]
                )
                ->add(
                    'amountMinVDAuto', MoneyType::class,
                    [
                        'divisor'  => 100,
                        'label'    => 'Minimum de perception Taxe Valeur Déclarée (€ H.T)',
                        'required' => false,
                    ]
                )
                ->add(
                    'amountVDAuto', MoneyType::class,
                    [
                        'divisor'  => 100,
                        'label'    => 'Ajout d\'un forfait pour l\'assurance (€ H.T)',
                        'required' => false,
                    ]
                )
                ->add(
                    'amountPercentVDAuto', PercentType::class,
                    [
                        'scale'    => 2,
                        'label'    => 'Pourcentage par rapport à la valeur déclarée (montant du panier) € H.T',
                        'required' => false,
                    ]
                )
                ->add(
                    'qtyMinVDAuto', integerType::class,
                    [
                        'label'    => 'Minimum quantity (équivalence bouteille) pour activer la taxe valeur déclarée',
                        'required' => false,
                    ]
                )
                ->add(
                    'amountFixedManu', MoneyType::class,
                    [
                        'divisor'  => 100,
                        'label'    => 'Frais de port fixe a ajouter en € (TTC ou H.T si TVA ci-dessous rempli)',
                        'required' => false,
                    ]
                )
                ->add(
                    'carrier', ChoiceType::class,
                    [
                        'label'    => 'Transporteur',
                        'choices'  => $this->choices,
                        'required' => false,
                    ]
                )
                ->add(
                    'file', FileType::class, ['label' => 'Fichier transporteur', 'required' => false]
                )
                ->add(
                    'fileSup', FileType::class, [
                        'label'    => 'Fichier transporteur (Haute Montagne)',
                        'required' => false,
                    ]
                );
        }

        $builder
            ->add(
                'marginAuto', PercentType::class, [
                    'scale'    => 2,
                    'label'    => 'Taxe ajoutée avant la taxe gazole',
                    'required' => false,
                ]
            )
            ->add(
                'marginGazoleAuto', PercentType::class, [
                    'scale'    => 2,
                    'label'    => 'Taxe gazole',
                    'required' => false,
                ]
            )
            ->add(
                'marginClientAuto', PercentType::class, [
                    'scale'    => 2,
                    'label'    => 'Taxe ajoutée après la taxe gazole',
                    'required' => false,
                ]
            )
            ->add(
                'amountFixedBeforeMargeAuto', MoneyType::class,
                [
                    'divisor'  => 100,
                    'label'    => 'Frais de port fixe a ajouter avant marge en € (H.T)',
                    'required' => false,
                ]
            )
            ->add(
                'amountFixedAuto', MoneyType::class,
                [
                    'divisor'  => 100,
                    'label'    => 'Frais de port fixe a ajouter après ajout taxe + taxe gazole en € (H.T)',
                    'required' => false,
                ]
            )
            ->add(
                'amountMarginBank', MoneyType::class, [
                    'divisor'  => 100,
                    'label'    => 'Marge de la banque sur la commande',
                    'required' => false,
                ]
            )
            ->add(
                'marginBank', PercentType::class, [
                    'scale'    => 2,
                    'label'    => 'Marge de la banque sur le prix total du panier',
                    'required' => false,
                ]
            )
            ->add(
                'highMountainAmount', MoneyType::class,
                [
                    'divisor'  => 100,
                    'label'    => 'Supplément Montagne ( € H.T, à ajouter pour Géodis, Transvins) ',
                    'required' => false,
                ]
            )
            ->add(
                'amountFreeShipping', MoneyType::class,
                [
                    'divisor'  => 100,
                    'label'    => 'Frais de port offert à partir de ( € TTC)',
                    'required' => false,
                ]
            )
            ->add(
                'translations', TranslationsType::class, [
                    'label'  => false,
                    'fields' => [
                        'shippingText' => [
                            'field_type' => TextType::class,
                            'label'      => 'Indiquer par un texte les délais de livraisons',
                            'required'   => true,
                        ],
                        'shippingInfo' => [
                            'field_type' => TrumbowygType::class,
                            'label'      => 'Détailler les frais de livraison par exemple.',
                            'required'   => false,
                        ],
                    ],
                ]
            )


        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => ShippingConfig::class,
            ]
        );
    }
}
