<?php
/**
 * @author Julien Colinet
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use A2lix\TranslationFormBundle\Form\Type\TranslationsType;
use CpCreation\VitiCore\Popup\Model\Popup;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\OptionsResolver\OptionsResolver;

class PopupType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'translations', TranslationsType::class, [
                'label'            => false,
                'fields'           => [
                    'title'    => [
                        'field_type' => TextType::class,
                        'label'      => 'Titre',
                        'required'   => true,
                    ],
                    'text'     => [
                        'field_type' => TrumbowygType::class,
                        'label'      => 'Texte',
                        'required'   => false,
                    ],

                ],
                'excluded_fields'  => ['slug']
            ])
            ->add(
                'image', ImageType::class, ['label' => 'Image pop-up']
            )
            ->add(
                'publishedAt', DateTimeType::class, [
                    'required' => false,
                    'label'    => 'Publier automatiquement le pop-up',
                    'input'    => 'datetime',
                    'format'   => 'yyyy-MM-dd HH:mm',
                    'html5'    => false,
                    'widget'   => 'single_text',
                    'attr'     => [
                    'class' => 'datetimepicker',

                    ],
                ]
            )
            ->add(
                'unPublishedAt', DateTimeType::class, [
                    'required' => false,
                    'label'    => 'Dépublier automatiquement le pop-up',
                    'input'    => 'datetime',
                    'format'   => 'yyyy-MM-dd HH:mm',
                    'html5'    => false,
                    'widget'   => 'single_text',
                    'attr'     => [
                        'class' => 'datetimepicker',

                    ],
                ]
            );
    }
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => Popup::class,
            ]
        );
    }
}

