<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use CpCreation\VitiCore\Cart\Model\PaymentMethod;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class PaymentMethodStep1Type extends AbstractType
{
    /**
     * @var array
     */
    private $choices;

    public function __construct($paymentMethods)
    {
        foreach ($paymentMethods as $method)
        {
            $this->choices[$method] = $method;
        }
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('method', ChoiceType::class, [
                'choices' => $this->choices,
                'label' => 'Choisir une méthode de paiement',
                'placeholder' => 'Aucun'
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => PaymentMethod::class
        ]);
    }

    public function getBlockPrefix() {
        return 'paymentMethodStep1';
    }

}